// osc.h - include file for the MBED Oscilloscope
// A simple oscilloscope function for the MBED with
// the application board.  Uses the onboard LCD
//
//  Author: Terry Richards
//
#ifndef __SIMP_OSC_H__
#define __SIMP_OSC_H__

//variables that keep track of horizontal time-base and 
//vertical volt_base.
unsigned int time_base = 1; //defaults to 512uS per div 
int tbsel = 0;
float volt_base = 1.0;
//variables to set the trigger level (uses pot2)
float trigger = 0.5, temptrig = 0.5;

//Used for all menu entries. The start of the selection marker
#define SELECTION_START     20 
#define MENU_LENGTH         26 

//enumerates the possible trigger modes for the scope
typedef enum
{
    main_rising_edge = 0,
    main_falling_edge,
    ext_rising_edge,
    ext_falling_edge,
    auto_no_trigger
} trigger_mode_type;

//Our tracker for mode in the main program
trigger_mode_type trigger_mode=main_rising_edge;
//Variables used for menu update
int trig_cur_sel=0, trig_cur_min = 0, trig_cur_max = 2;
//these strings will be shown when the trigger menu is displayed
char trigstrings[][MENU_LENGTH] = {
    "Rising Edge Main    **** ",
    "Falling Edge Main        ",
    "Rising Edge Ext          ",
    "Falling Edge Ext         ",
    "Auto - No Trigger        ",
};
//0 through 4 where 4 is the last entry
#define MAX_TRIG_MENU       4
//Variables used to display the grid menu
int grid_cur_sel=0, grid_cur_min = 0, grid_cur_max = 1;
//Strings for the grid menu
char gridstrings[][MENU_LENGTH] = {
    "No Grid             **** ",
    "Draw Grid                "
};
//0 through 1
#define MAX_GRID_MENU       1
//grid tracker for main program
bool draw_grid = false;

#endif