
#ifndef __owInterface_h
#define __owInterface_h

//For testing the One-Wire (OW) ports below
//#define OWPORT  1     //test port (LED)
//#define OWPIN   20

//Selects the direction and pin for the main One Wire input/output
#define OWFIOPIN (*(volatile unsigned int *)(0x2009C000 | ((OWPORT*0x20)+0x10) | 4 ))
#define OWFIODIR (*(volatile unsigned int *)(0x2009C000 | (OWPORT*0x20)))
//Provides a test pin near the OW to test the OW output
#define TESTFIOPIN (*(volatile unsigned int *)(0x2009C000 | ((TESTPRT*0x20)+0x10) | 4 ))
#define TESTFIODIR (*(volatile unsigned int *)(0x2009C000 | (TESTPRT*0x20)))

//MBED pin 25 resolves to port 2 pin 1
#define OWPORT  2
#define OWPIN   1
//MBED pin 26 is near 25 for testing
#define TESTPRT 2
#define TESTPIN 0

//Set the selected Pin to one
void __inline__ set_owPin(void)
{
    OWFIODIR |= 1 << OWPIN;   //Set pin direction to output
    OWFIOPIN |= 1 << OWPIN;   //Set pin state (1)
}
//Set the selected pin to zero
void __inline__ clr_owPin(void)
{
    OWFIODIR |= 1 << OWPIN;   //Set pin direction to output
    OWFIOPIN &= ~(1 << OWPIN);//Clear pin state (0)
}
//Reads the pin, but also sets direction to input
int __inline__ read_owPin(void)
{
    OWFIODIR &= ~(1<<OWPIN);  //Set pin direction to input
    return ((OWFIOPIN>>OWPIN)&0x1);   //Return the pin state
}
//Test pin to see the write bits on the OW
int __inline__ read_testPin(void)
{
    TESTFIODIR &= ~(1<<TESTPIN);
    return ((TESTFIOPIN>>TESTPIN)&0x1);
}
//Timer control registers
#define TIMER3_TCR  (*(volatile unsigned int *)(0x40094004))
#define TIMER3_TC   (*(volatile unsigned int *)(0x40094008))
#define TIMER3_PR   (*(volatile unsigned int *)(0x4009400C))
#define TIMER3_CTCR (*(volatile unsigned int *)(0x40094070))
#define PWRCTL_PCONP (*(volatile unsigned int *)(0x400FC0C4))
#define SYS_CLK     96000000

void init_timer(void)
{
   PWRCTL_PCONP |= 1<<23;   //Power up timer3
   TIMER3_CTCR = 0;         //set to timer (not counter)
   TIMER3_TCR = 0x2;        //Put timer in reset
   TIMER3_PR = ((SYS_CLK / 4000000) - 1); //One us per tick
   TIMER3_TCR = 0x1;        //enable timer
}
//Delay for "dly_us" us (microSeconds)
void __inline__ delay_us(unsigned int dly_us)
{
    unsigned int startt = TIMER3_TC;
    while ((TIMER3_TC-startt) < dly_us) ;
}

#endif