// Project includes
#include "globals.h"
#include "hardware.h"
#include "map.h"
#include "graphics.h"
#include "speech.h"


// Functions in this file
int get_action (GameInputs inputs);
int update_game (int action);
void draw_game (int init);
void init_main_map ();
int main ();


//MYCODE
GameInputs gInputs;
int        action;
int        gUpdate;
int        omnipotent;
int        hasSonar;

int dialogueNumNPC = 0;
int dialogueNumPris = 0;
//animationstuff
int updateCount = 0;

//NPC
int NPCx = 6;
int NPCy = 5;
int walkCycleNPC = 0;

//speech
char *talk1 = "";

int go_up(int x, int y);
int go_down(int x, int y);
int go_right(int x, int y);
int go_left(int x, int y);
int action_button(int x, int y);
void init_map2();
void animation_update();
void moveNPC();

void spawnTreasure();
void spawnLakeTreasure();
void treasureSparkle();
int fakeLakeTreasure = 1;
int fakeTreasure = 1;
int hasBoat = 0;
int treasureX;
int treasureY;

int lakeTreasureX;
int lakeTreasureY;

int needBoat = 0;
void checkNeedBoat();

void startScreen();
void endScreen();

void pickUpSound();
void ladderSound();



/**
 * The main game state. Must include Player locations and previous locations for
 * drawing to work properly. Other items can be added as needed.
 */
struct {
    int x,y;    // Current locations
    int px, py; // Previous locations
    int has_key;
    
    //MYCODE
    //int omnipotent;
    // You can add other properties for the player here
} Player;


/**
 * Given the game inputs, determine what kind of update needs to happen.
 * Possbile return values are defined below.
 */
#define NO_ACTION 0
#define ACTION_BUTTON 1
#define MENU_BUTTON 2
#define GO_LEFT 3
#define GO_RIGHT 4
#define GO_UP 5
#define GO_DOWN 6
//#define ACTION_BUTTON 7
int get_action(GameInputs inputs)
{
    //MYCODE
    //accelerometer cases
    if(inputs.ax >= 0.4){
        return GO_RIGHT;   
    }
    if(inputs.ax < -0.4){
        return GO_LEFT;   
    }
    if(inputs.ay >= 0.4){
        return GO_UP;   
    }
    if(inputs.ay < -0.15){
        return GO_DOWN;   
    }
    
    if(!inputs.b1){
        if(omnipotent != 1){    
             omnipotent = 1;
        }
        else{
             omnipotent = 0;  
        }
        wait(1);  
    }
    
    if(!inputs.b3){
        return  ACTION_BUTTON;  
    }
    
    //ENDMYCODE
    return NO_ACTION;
}

/**
 * Update the game state based on the user action. For example, if the user
 * requests GO_UP, then this function should determine if that is possible by
 * consulting the map, and update the Player position accordingly.
 * 
 * Return values are defined below. FULL_DRAW indicates that for this frame,
 * draw_game should not optimize drawing and should draw every tile, even if
 * the player has not moved.
 */
#define NO_RESULT 0
#define GAME_OVER 1
#define FULL_DRAW 2
int update_game(int action)
{
    // Save player previous location before updating
    Player.px = Player.x;
    Player.py = Player.y;
    
    //MYCODE
    animation_update();
    //ENDMYCODE
    
    // Do different things based on the each action.
    // You can define functions like "go_up()" that get called for each case.
    switch(action)
    {
        case GO_UP:
            //MYCODE
            if(go_up(Player.px, Player.py)){
                return FULL_DRAW;    
            }
            else{
                break;
            }
        case GO_LEFT:
            if(go_left(Player.px, Player.py)){
                return FULL_DRAW;    
            }
            else{
                break;
            }            
        case GO_DOWN:
            if(go_down(Player.px, Player.py)){
                return FULL_DRAW;    
            }
            else{
                break;
            }
        case GO_RIGHT: 
            if(go_right(Player.px, Player.py)){
                return FULL_DRAW;    
            }
            else{
                break;
            }
        case ACTION_BUTTON:
            if(action_button(Player.px, Player.py)){
                return FULL_DRAW;    
            }
            else{
                break;
            }
        case MENU_BUTTON: break;
        default:        break;
    }
    return FULL_DRAW;
}

//MYCODE
int go_up(int x, int y){
    MapItem *northItem = get_north(x, y);
    if(northItem->walkable || omnipotent || (hasBoat && northItem->type == water)){
        Player.y--;
        
        checkNeedBoat();
        return 1;    
    }    
    return 0;
}
int go_down(int x, int y){
    MapItem *southItem = get_south(x, y);
    if(southItem->walkable || omnipotent || (hasBoat && southItem->type == water)){
        Player.y++;
        checkNeedBoat();
        return 1;    
    }    
    return 0;
}
int go_left(int x, int y){
    MapItem *westItem = get_west(x, y);
    if(westItem->walkable || omnipotent || (hasBoat && westItem->type == water)){
        Player.x--;
        checkNeedBoat();
        return 1;    
    }    
    return 0;
}
int go_right(int x, int y){
    MapItem *eastItem = get_east(x, y);
    if(eastItem->walkable || omnipotent || (hasBoat && eastItem->type == water)){
        Player.x++;
        checkNeedBoat();
        return 1;    
    }    
    return 0;
}

// || (hasBoat && eastItem->type == water)

int action_button(int x, int y){
    MapItem *eastItem = get_east(x, y);
    MapItem *westItem = get_west(x, y);
    MapItem *southItem = get_south(x, y);
    MapItem *northItem = get_north(x, y);
    MapItem *hereItem = get_here(x, y);
    
    
    
    //eastItem || westItem || northItem || southItem || hereItem 
    if(eastItem -> type == NPC || westItem -> type == NPC || northItem  -> type == NPC || southItem -> type == NPC || hereItem -> type == NPC){
        
        if(dialogueNumNPC == 0){
                         //1234567890123456X8901234567890123X5679012345678901X1234567890
            char *talk2 = "There's a ladder SOUTH of here    where you can geta sonar.";
            speech(talk1, talk2);
            add_ladder(8, 40);
            dialogueNumNPC = 1;
            
        }
        else if(dialogueNumNPC == 1){
                         //1234567890123456X8901234567890123X567901234567890
            char *talk2 = "It's around the  lake, between    two rocks.";
            speech(talk1, talk2);
            
        }
       //map_erase(NPCx,NPCy-1); 
        
    }
    //ladder interaction
    else if(eastItem -> type == ladder || westItem -> type == ladder || northItem  -> type == ladder || southItem -> type == ladder || hereItem -> type == ladder){
        //add_ladder(8, 8);
        
        ladderSound();
        map_erase(8, 40);    
        init_map2();
    }
    //sonar interation
    else if(eastItem -> type == sonar || westItem -> type == sonar || northItem  -> type == sonar || southItem -> type == sonar || hereItem -> type == sonar){
        
        pickUpSound();
                     //1234567890123456789012345678901234567901234567890
        char *talk2 = "You found the    sonar!!!";
        speech(talk1, talk2);
        
        map_erase(14, 8);       //erase the sonar
        init_main_map();        //switch back to main map
        Player.x = 8;           //CHANGE to cords of new ladder when done
        Player.y = 40;
        
        spawnTreasure();        //spawn the treasure
        hasSonar = 1;           //allow player to use sonar
    }
    
    else if(eastItem -> type == keyItem || westItem -> type == keyItem || northItem  -> type == keyItem || southItem -> type == keyItem || hereItem -> type == keyItem){
        
        pickUpSound();
                     //1234567890123456789012345678901234567901234567890
        char *talk2 = "You found a key. I wonder what it opens?";
        speech(talk1, talk2);
        map_erase(18, 8);
        Player.has_key = 1;
    }
    
    else if(eastItem -> type == treasure || westItem -> type == treasure || northItem  -> type == treasure || southItem -> type == treasure || hereItem -> type == treasure){
        //add_ladder(8, 8);
        if(fakeTreasure == 1){//first treasure found so it is fake
                         //1234567890123456789012345678901234567901234567890
            char *talk2 = "That treasure    was fake.";
            speech(talk1, talk2);
            
            map_erase(treasureX, treasureY);
            spawnTreasure();
            fakeTreasure = 0;
        }
        else{ //do a game over screen
            endScreen();  
        }
    }
    
    //gate stuff
     else if(eastItem -> type == gate || westItem -> type == gate || northItem  -> type == gate || southItem -> type == gate || hereItem -> type == gate){
           if(Player.has_key){
                pickUpSound();
                             //123456789012345678901234567890123X567901234567890
                char *talk2 = "You used your keyto unlock the    gate."; 
                speech(talk1, talk2);
                
                map_erase(33, 5);
           }
           else{
               char *talk2 = "It's locked."; 
               speech(talk1, talk2);
           }
     }
     
     else if(eastItem -> type == prisoner || westItem -> type == prisoner || northItem  -> type == prisoner || southItem -> type == prisoner || hereItem -> type == prisoner){
            if(dialogueNumPris == 0){
                             //1234567890123456X8901234567890123X5679012345678901X1234567890123456X1234567890123456X1234567890123456X
                char *talk2 = "Hey... you just  like freed me    from this jail...";
                speech(talk1, talk2);
                             //1234567890123456X8901234567890123X5679012345678901X1234567890123456X1234567890123456X1234567890123456X
                char *talk3 = "I was going to   use this BOAT to bust out... But  I guess you can  have it now.";
                speech(talk1, talk3);
                
                pickUpSound();
                char *talk4 = "You got a BOAT!  You can travel   over water now!";
                speech(talk1, talk4);
                
                spawnLakeTreasure();
                
                hasBoat = 1;
                dialogueNumPris = 1;
                map_erase(33,1);
            }
            else if(dialogueNumPris == 1){
                            //1234567890123456X8901234567890123X5679012345678901X1234567890123456X1234567890123456X1234567890123456X
                char *talk2 = "Kinda forgot why I made a boat in the first        place...";
                speech(talk1, talk2);
                             //1234567890123456X8901234567890123X5679012345678901X1234567890123456X
                char *talk3 = "Something to do  with a lake and  treasure... "; 
                speech(talk1, talk3);   
            }
            
            
            
     }
    
    
    //no items found so give the speech based on whether he has the sonar or not
    else{
        if(!hasSonar){
                         //1234567890123456X8901234567890123X567901234567890
            char *talk2 = "You do not have  the sonar.";  
            speech(talk1, talk2);
        }
        else{
            
            //char buffer[50];
            //sprintf(buffer, "%d, %d", treasureX, treasureY);
            if(get_here(Player.x, Player.y) -> type != water){//player is in the water
                              //1234567890123456X8901234567890123X567901234567890
                char *talk2 = "The sonar says:";
                char *talkWest = "West";
                char *talkEast = "East";
                char *talkNorth = "North";
                char *talkSouth = "South";
                speech(talk1, talk2);
                
                if(treasureX > Player.x) speech(talk1, talkEast);
                if(treasureX < Player.x) speech(talk1, talkWest);
                if(treasureY > Player.y) speech(talk1, talkSouth);
                if(treasureY < Player.y) speech(talk1, talkNorth);
            }
            else{
                if(Player.x == lakeTreasureX && Player.y == lakeTreasureY){//player is on the treasure
                                 //1234567890123456X8901234567890123X567901234567890
                    char *talk2 = "There's          something down   here!";
                    speech(talk1, talk2);
                    
                    if(fakeLakeTreasure){//tres is fake
                                     //1234567890123456X8901234567890123X567901234567890
                        char *talk3 = "It's just an old boot :(";
                        speech(talk1, talk3);
                        fakeLakeTreasure = 0;
                        spawnLakeTreasure();
                    }
                    else{//tres is real
                                     //1234567890123456X8901234567890123X1234567890123456X1234567890123456X
                        char *talk3 = "It's a giant     treasure chest!  You gleefully    throw it onto theshore!";
                        speech(talk1, talk3);
                        
                        fakeTreasure = 0;
                        add_treasure(13,11);
                    }
                    
                }
                else{
                    char *talk2 = "The sonar says:";
                    speech(talk1, talk2);
                                 //1234567890123456X8901234567890123X567901234567890
                    char *talk3 = "Look for a       shimmer in the   sea...";
                    speech(talk1, talk3);
                    //char buffer[50];
                    //sprintf(buffer, "%d, %d", lakeTreasureX, lakeTreasureY);
                    //speech(talk1, buffer);
                    treasureSparkle();
                }
            }
        }
        
    }
    
    return 1;
}

/**
 * Entry point for frame drawing. This should be called once per iteration of
 * the game loop. This draws all tiles on the screen, followed by the status 
 * bars. Unless init is nonzero, this function will optimize drawing by only 
 * drawing tiles that have changed from the previous frame.
 */
void draw_game(int init)
{
    // Draw game border first
    if(init) draw_border();
    
    // Iterate over all visible map tiles
    for (int i = -5; i <= 5; i++) // Iterate over columns of tiles
    {
        for (int j = -4; j <= 4; j++) // Iterate over one column of tiles
        {
            // Here, we have a given (i,j)
            
            // Compute the current map (x,y) of this tile
            int x = i + Player.x;
            int y = j + Player.y;
            
            // Compute the previous map (px, py) of this tile
            int px = i + Player.px;
            int py = j + Player.py;
                        
            // Compute u,v coordinates for drawing
            int u = (i+5)*11 + 3;
            int v = (j+4)*11 + 15;
            
            // Figure out what to draw
            DrawFunc draw = NULL;
            if (init && i == 0 && j == 0) // Only draw the player on init
            {
                draw_player(u, v, Player.has_key, needBoat);
                continue;
            }
            else if (x >= 0 && y >= 0 && x < map_width() && y < map_height()) // Current (i,j) in the map
            {
                MapItem* curr_item = get_here(x, y);
                MapItem* prev_item = get_here(px, py);
                if (init || curr_item != prev_item) // Only draw if they're different
                {
                    if (curr_item) // There's something here! Draw it
                    {
                        draw = curr_item->draw;
                    }
                    else // There used to be something, but now there isn't
                    {
                        draw = draw_nothing;
                    }
                }
            }
            else if (init) // If doing a full draw, but we're out of bounds, draw the walls.
            {
                draw = draw_wall;
            }

            // Actually draw the tile
            if (draw) draw(u, v);
        }
    }

    // Draw status bars
    if(Player.x != Player.px || Player.y != Player.py){ 
         draw_upper_status(Player.x, Player.y);
     }
    
    draw_lower_status();
}


/**
 * Initialize the main world map. Add walls around the edges, interior chambers,
 * and plants in the background so you can see motion. Note: using the similar
 * procedure you can init the secondary map(s).
 */
void init_main_map()
{
    // "Random" plants
    Map* map = set_active_map(0);
    
    /*OGCODE
    for(int i = map_width() + 3; i < map_area(); i += 39)
    {
        add_plant(i % map_width(), i / map_width());
    }
    pc.printf("plants\r\n");
    */
    
    //adds plants in random locations
    int numberOfPlants = 75;
    
    srand (time(NULL));
    while(numberOfPlants > 0){
        add_plant((rand()%70 + 2), (rand()%45+2));\
        numberOfPlants--;   
    }
    
    
    pc.printf("Adding walls!\r\n");
    add_wall(0,              0,              HORIZONTAL, map_width());
    add_wall(0,              map_height()-1, HORIZONTAL, map_width());
    add_wall(0,              0,              VERTICAL,   map_height());
    add_wall(map_width()-1,  0,              VERTICAL,   map_height());
    pc.printf("Walls done!\r\n");
    

    //MYCODE
    add_NPC(6, 5);
    
    
    //TESTING
    //ENDTESTING
    //lake1
    add_water(4, 8, HORIZONTAL, 5);
    add_water(3, 9, HORIZONTAL, 7);
    add_water(3, 10, HORIZONTAL, 9);
    add_water(3, 11, HORIZONTAL, 9);
    add_water(3, 12, HORIZONTAL, 9);
    add_water(3, 13, HORIZONTAL, 7);
    add_water(4, 14, HORIZONTAL, 5);
    
    
    //ROCKS!!!
    
    add_rock(4, 39, HORIZONTAL, 2);
    add_rock(3, 40, HORIZONTAL, 3);
    
    add_rock(9, 39, HORIZONTAL, 2);
    add_rock(9, 40, HORIZONTAL, 3);

    //WOOD "HOUSE"
    add_wood(30, 1, HORIZONTAL, 1);
    add_wood(36, 1, HORIZONTAL, 1);
    
    add_wood(30, 2, HORIZONTAL, 1);
    add_wood(36, 2, HORIZONTAL, 1);
    
    add_wood(30, 3, HORIZONTAL, 1);
    add_wood(36, 3, HORIZONTAL, 1);
    
    add_wood(30, 4, HORIZONTAL, 1);
    add_wood(36, 4, HORIZONTAL, 1);
    
    add_wood(30, 5, HORIZONTAL, 3);
    add_wood(34, 5, HORIZONTAL, 3);
    
    add_gate(33,5);
    
    add_prisoner(33, 2);
    add_expPnt(33, 1);
    
    //TESTING
    
    print_map();
}

/**
 * Program entry point! This is where it all begins.
 * This function orchestrates all the parts of the game. Most of your
 * implementation should be elsewhere - this holds the game loop, and should
 * read like a road map for the rest of the code.
 */
int main()
{
    // First things first: initialize hardware
    ASSERT_P(hardware_init() == ERROR_NONE, "Hardware init failed!");
    
    //MYCODE
    startScreen();
    // Initialize the maps
    maps_init();
    init_main_map();
    
    // Initialize game state
    set_active_map(0);
    Player.x = Player.y = 5;
    
    //MYCODE
    omnipotent = 0;
    hasSonar = 0;
    
    // Initial drawing
    draw_game(true);

    // Main game loop
    while(1)
    {
        // Timer to measure game update speed
        Timer t; t.start();
        
        // Actuall do the game update:
        // 1. Read inputs
        //MYCODE 
        gInputs = read_inputs();
                
        // 2. Determine action (get_action)  
        //MYCODE 
        action = get_action(gInputs);     
        
        // 3. Update game (update_game)
        //MYCODE
        gUpdate = update_game(action);
        // 3b. Check for game over
        
        
        // 4. Draw frame (draw_game)
        draw_game(gUpdate);
        
        // 5. Frame delay
        t.stop();
        int dt = t.read_ms();
        if (dt < 100) wait_ms(100 - dt);
    }
}

//MYCODE
void init_map2()
{
    Map* map = set_active_map(1);
    
    Player.x = 2;
    Player.y = 2;
    
    pc.printf("Adding walls!\r\n");
    add_wall(0,              0,              HORIZONTAL, map_width());
    add_wall(0,              map_height()-1, HORIZONTAL, map_width());
    add_wall(0,              0,              VERTICAL,   map_height());
    add_wall(map_width()-1,  0,              VERTICAL,   map_height());
    pc.printf("Walls done!\r\n");
    
    //INTERIOR WALLS
    add_wall(4, 1, VERTICAL, 5);
    
    add_wall(8, 1, VERTICAL, 3);
    add_wall(8, 5, VERTICAL, 3);
    
    add_wall(9, 5, HORIZONTAL, 4);
    add_wall(12, 5, VERTICAL, 4);
    
    add_wall(9, 5, HORIZONTAL, 4);
    add_wall(12, 2, VERTICAL, 9);
    
    add_wall(15, 4, VERTICAL, 9);
    add_wall(16, 4, VERTICAL, 9);
    
    add_sonar(14, 8);
    add_key(18, 8);
    
    print_map();
}

//STARTSCREEN
void startScreen(){
    uLCD.filled_rectangle(0, 0, 128, 128, BLACK);
    
    uLCD.locate(2, 1);
    uLCD.color(WHITE);
    uLCD.text_width(1);
    uLCD.text_height(1);
            
    uLCD.printf("   GET THAT\n    TREASURE!!\n\n     Press The\n   Action Button\n     To START");
            
    uLCD.filled_rectangle(0, 0, 128, 2, BLUE);//top
    uLCD.filled_rectangle(0, 0, 2, 128, BLUE);//bottom
    
    uLCD.filled_rectangle(0, 126, 128, 128, BLUE);
    uLCD.filled_rectangle(126, 0, 128, 128, BLUE); 
    
    GameInputs startInputs = read_inputs();
    while(startInputs.b3){//while button not pressed
        startInputs = read_inputs();        
    }
    
    uLCD.filled_rectangle(0, 0, 128, 128, BLACK);
    
}



//once every 10 in game cycles the aniamtions and npc movements will happen
void animation_update(){
    updateCount++;
    if(updateCount > 9){
        moveNPC();
        updateCount = 0;   
    }    
}

void moveNPC(){
    if(map_width() == 75){
        map_erase(NPCx, NPCy);
        
        
        map_erase(NPCx, NPCy-1);
        //walkCycleNPC = 0 => go right
        //wCNPC = 1 => go left
        if(NPCx < 10 && !walkCycleNPC) NPCx++;
        else if(NPCx > 2) NPCx--;
        
        if(NPCx == 10) walkCycleNPC = 1;
        else if(NPCx == 2) walkCycleNPC = 0;
            
        add_NPC(NPCx, NPCy);  
        if(dialogueNumNPC == 0) add_expPnt(NPCx,NPCy-1);//NPC has something important to say
        
    }
     
}

void spawnTreasure(){
    
        srand (time(NULL));
        treasureX = (rand()%45) + 25;   //rand x cord for treasure
        treasureY = (rand()%30) + 15;   //rand y cord for treasure
        
        add_treasure(treasureX, treasureY);
}

void spawnLakeTreasure(){
    
        srand (time(NULL));
        lakeTreasureX = (rand()%5) + 4;   //rand x cord for treasure
        lakeTreasureY = (rand()%7) + 8;   //rand y cord for treasure
        
}

void treasureSparkle(){
        
        add_waterS1(lakeTreasureX, lakeTreasureY);
        draw_game(FULL_DRAW);
        wait_ms(500);
        
        add_waterS2(lakeTreasureX, lakeTreasureY);
        draw_game(FULL_DRAW);
        wait_ms(500);
        add_water(lakeTreasureX, lakeTreasureY, HORIZONTAL, 1);
}

void checkNeedBoat(){
    if(get_here(Player.x, Player.y) -> type == water){
      needBoat = 1;   
    }
    else{
      needBoat = 0;   
    }
}


void pickUpSound(){
    speaker.period(1.0/98);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
    wait_ms(50);  
    
    speaker.period(1.0/110);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
    wait_ms(50);
    
    speaker.period(1.0/123);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
    wait_ms(50); 
    
    speaker.period(1.0/130);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
}

void ladderSound(){
    speaker.period(1.0/130);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
    wait_ms(50);  
    
    speaker.period(1.0/123);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
    wait_ms(50);
    
    speaker.period(1.0/110);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
    wait_ms(50); 
    
    speaker.period(1.0/98);
    speaker = 0.01;
    wait_ms(100);
    speaker = 0;
}

void endScreen(){
            uLCD.filled_rectangle(0, 0, 128, 128, BLACK);
    
            
            
            uLCD.locate(2, 1);
            uLCD.color(WHITE);
            uLCD.text_width(1);
            uLCD.text_height(1);
            
            uLCD.printf("   YOU WON!\n\n      Thanks\n       For\n     Playing!!");
            
            uLCD.filled_rectangle(0, 0, 128, 2, BLUE);//top
            uLCD.filled_rectangle(0, 0, 2, 128, BLUE);//bottom
    
            uLCD.filled_rectangle(0, 126, 128, 128, BLUE);
            uLCD.filled_rectangle(126, 0, 128, 128, BLUE); 
            
            
            
                
           int nWait = 100;
           //int speakerVolume = 0.1;
           while(true){
                //MEME
                
                //intro1
                
                speaker.period(1.0/369);
                speaker = 0.01;
                wait_ms(350);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/293);
                wait_ms(350);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/293);
                wait_ms(100);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/329);
                wait_ms(100);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/349);
                wait_ms(200);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/329);
                wait_ms(250);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/293);
                wait_ms(200);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/277);
                wait_ms(250);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/293);
                wait_ms(250);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/329);
                wait_ms(150);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/369);
                wait_ms(250);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/369);
                wait_ms(100);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/493);
                wait_ms(350);
                speaker = 0;
                wait_ms(nWait);
                
                //endintro1
                //intro1-2
                speaker = 0.01;
                speaker.period(1.0/246);
                wait_ms(150);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/277);
                wait_ms(150);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/293);
                wait_ms(250);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/329);
                wait_ms(250);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/293);
                wait_ms(150);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/277);
                wait_ms(200);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/440);
                wait_ms(200);
                speaker = 0;
                wait_ms(nWait);
                
                speaker = 0.01;
                speaker.period(1.0/391);
                wait_ms(150);
                speaker = 0;
                wait_ms(nWait);
                //endintro1-2
                //END MEME   
            }      
}
