#ifndef GRAPHICS_H
#define GRAPHICS_H


/**
 * Draws the player. This depends on the player state, so it is not a DrawFunc.
 */
void draw_player(int u, int v, int key, int needBoat);

/**
 * Takes a string image and draws it to the screen. The string is 121 characters
 * long, and represents an 11x11 tile in row-major ordering (across, then down,
 * like a regular multi-dimensional array). The available colors are:
 *      R = Red
 *      Y = Yellow
 *      G = Green
 *      D = Brown ("dirt")
 *      5 = Light grey (50%)
 *      3 = Dark grey (30%)
 *      Any other character is black
 * More colors can be easily added by following the pattern already given.
 */
void draw_img(int u, int v, const char* img);

/**
 * DrawFunc functions. 
 * These can be used as the MapItem draw functions.
 */
void draw_nothing(int u, int v);
void draw_wall(int u, int v);
void draw_plant(int u, int v);

//MYCODE
void draw_NPC(int u, int v);
void draw_ladder(int u, int v);
void draw_key(int u, int v);
void draw_sonar(int u, int v);
void draw_treasure(int u, int v);
void draw_gate(int u, int v);
void draw_water(int u, int v);
void draw_waterS1(int u, int v);
void draw_waterS2(int u, int v);
void draw_rock(int u, int v);
void draw_wood(int u, int v);
void draw_prisoner(int u, int v);

void draw_expPnt(int u, int v);
/**
 * Draw the upper status bar.
 */
void draw_upper_status(int playerX, int playerY);

/**
 * Draw the lower status bar.
 */ 
void draw_lower_status();

/**
 * Draw the border for the map.
 */
void draw_border();

#endif // GRAPHICS_H