#include "map.h"

#include "globals.h"
#include "graphics.h"

/**
 * The Map structure. This holds a HashTable for all the MapItems, along with
 * values for the width and height of the Map.
 */
struct Map {
    HashTable* items;
    int w, h;
};

/**
 * Storage area for the maps.
 * This is a global variable, but can only be access from this file because it
 * is static.
 */
static Map map;
static int active_map;

//MYCODE 
static Map map2;

//array of maps
static Map maps[2];


/**
 * The first step in HashTable access for the map is turning the two-dimensional
 * key information (x, y) into a one-dimensional unsigned integer.
 * This function should uniquely map (x,y) onto the space of unsigned integers.
 */
static unsigned XY_KEY(int X, int Y) {
    // TODO: Fix me!
    
    //MYCODE
    return ((X*map.h) + Y); //multiplies X by height of map to get the row, then adds y for the column
}

/**
 * This is the hash function actually passed into createHashTable. It takes an
 * unsigned key (the output of XY_KEY) and turns it into a hash value (some
 * small non-negative integer).
 */
unsigned map_hash(unsigned key)
{
    // TODO: Fix me!
    
    //MYCODE
    return key%NUMBUCKETS; //NB = 75
}

void maps_init()
{
    // TODO: Implement!    
    // Initialize hash table
    // Set width & height
    
    //MYCODE
    map.items = createHashTable(map_hash, NUMBUCKETS);//NB = 75
    map.w = MAPWIDTH;  //75
    map.h = MAPHEIGHT; //75
    maps[0] = map;
    
    map2.items = createHashTable(map_hash, NUMBUCKETS);
    map2.w = MAP2WIDTH;     //20
    map2.h = MAP2HEIGHT;    //10
    maps[1] = map2;
}

Map* get_active_map()
{
    //OGCODE
    // There's only one map
    //return &map;
    
    return &(maps[active_map]);
    
   
    
}

Map* set_active_map(int m)
{
    //OGCODE
    //active_map = m;
    //return &map;
    
    active_map = m;
    return &(maps[m]);
    
}

void print_map()
{
    // As you add more types, you'll need to add more items to this array.
    char lookup[] = {'W', 'P'};
    for(int y = 0; y < map_height(); y++)
    {
        for (int x = 0; x < map_width(); x++)
        {
            MapItem* item = get_here(x,y);
            if (item) pc.printf("%c", lookup[item->type]);
            else pc.printf(" ");
        }
        pc.printf("\r\n");
    }
}


//MYCODE
int map_width()
{
    //need to get active map
    Map *map = get_active_map();
    return map->w;
}

//MYCODE
int map_height()
{
    Map *map = get_active_map();
    return map->h;
}

//MYCODE
int map_area()
{
 
    Map *map = get_active_map();
    return (map->h * map->w);
}

//MYCODE
MapItem* get_north(int x, int y)
{
    Map *thisMap = get_active_map();
    int thisKey = XY_KEY(x, y-1);
    return (MapItem*) getItem(thisMap->items,thisKey);
}

MapItem* get_south(int x, int y)
{
    Map *thisMap = get_active_map();
    int thisKey = XY_KEY(x, y+1);
    return (MapItem*) getItem(thisMap->items,thisKey);
}

MapItem* get_east(int x, int y)
{
    Map *thisMap = get_active_map();
    int thisKey = XY_KEY(x+1, y);
    return (MapItem*) getItem(thisMap->items,thisKey);
}

MapItem* get_west(int x, int y)
{
    Map *thisMap = get_active_map();
    int thisKey = XY_KEY(x-1, y);
    return (MapItem*) getItem(thisMap->items,thisKey);
}

MapItem* get_here(int x, int y)
{
    Map *thisMap = get_active_map();
    int thisKey = XY_KEY(x, y);
    return (MapItem*) getItem(thisMap->items,thisKey);
}


void map_erase(int x, int y)
{
    Map *thisMap = get_active_map();
    int thisKey = XY_KEY(x, y);
    deleteItem(thisMap->items,thisKey);
}

void add_wall(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = WALL;
        w1->draw = draw_wall;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_plant(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PLANT;
    w1->draw = draw_plant;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

//MYCODE
void add_NPC(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = NPC;
    w1->draw = draw_NPC;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_ladder(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = ladder;
    w1->draw = draw_ladder;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}

void add_key(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = keyItem;
    w1->draw = draw_key;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}

void add_sonar(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = sonar;
    w1->draw = draw_sonar;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}

void add_treasure(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = treasure;
    w1->draw = draw_treasure;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}


void add_gate(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = gate;
    w1->draw = draw_gate;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}

void add_prisoner(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = prisoner;
    w1->draw = draw_prisoner;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}

void add_expPnt(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = expPnt;
    w1->draw = draw_expPnt;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}

void add_water(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = water;
        w1->draw = draw_water;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_rock(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = rock;
        w1->draw = draw_rock;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_wood(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = wood;
        w1->draw = draw_wood;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}


void add_waterS1(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = waterS1;
    w1->draw = draw_waterS1;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}


void add_waterS2(int x, int y){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = waterS2;
    w1->draw = draw_waterS2;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it   
}
