#include "speech.h"

#include "globals.h"
#include "hardware.h"

/**
 * Draw the speech bubble background.
 */
static void draw_speech_bubble();

/**
 * Erase the speech bubble.
 */
static void erase_speech_bubble();

/**
 * Draw a single line of the speech bubble.
 * @param line The text to display
 * @param which If TOP, the first line; if BOTTOM, the second line.
 */
#define TOP    0
#define BOTTOM 1
static void draw_speech_line(const char* line, int which);

/**
 * Delay until it is time to scroll.
 */
static void speech_bubble_wait();

void draw_speech_bubble()
{   
    //MYCODE
    uLCD.filled_rectangle(0, 75, 128, 128, BLACK);
    
    uLCD.filled_rectangle(0, 74, 128, 75, BLUE);//top
    uLCD.filled_rectangle(0, 127, 128, 128, BLUE);//bottom
    
    uLCD.filled_rectangle(0, 75, 1, 128, BLUE);
    uLCD.filled_rectangle(127, 75, 128, 128, BLUE);
}

void erase_speech_bubble()
{
    uLCD.filled_rectangle(0, 117, 128, 128, BLACK);
}

void draw_speech_line(const char* line, int which)
{
    //MYCODE
    int locateY = 10;
    uLCD.locate(1, locateY);
    uLCD.color(WHITE);
    uLCD.text_width(1);
    uLCD.text_height(1);
    //every 17 characters go down a line
    for(int i = 0; i < strlen(line); i++){//each char in line
        if(i%17 == 0 && i != 0){//hit 17th character
            locateY++;
            uLCD.locate(1, locateY);
        }   
        uLCD.printf("%c", line[i]);
        
        //SANS TEST
        speaker = 0.001;
        speaker.period(1.0/160);
        wait_ms(15);
        speaker = 0;
        wait_ms(10);
        //ENDSANS TEST
        
        //wait_ms(25);
    }
    
    
    //prints on top line
    //17 chars per line
    /*KINDA WORKS
    uLCD.locate(1, 10);
    uLCD.color(WHITE);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.printf("123456789qwertyui");
    
    //prints on next line down
    uLCD.locate(1, 11);
    uLCD.color(WHITE);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.printf("opasdfas");*/

}

void speech_bubble_wait()
{
    wait_ms(1500);
}

void speech(const char* line1, const char* line2)
{
    draw_speech_bubble();
    draw_speech_line(line1, TOP);
    draw_speech_line(line2, BOTTOM);
    speech_bubble_wait();
    erase_speech_bubble();
}

void long_speech(const char* lines[], int n)
{
}
