#include "graphics.h"

#include "globals.h"



void draw_player(int u, int v, int key, int needBoat)
{
    //OGCODE
    //uLCD.filled_rectangle(u, v, u+11, v+11, RED);
    
    //MYCODE
    if(needBoat == 0){
        char playerSprite[122] = "0000000000000QQQQQQQ0000QUUUUUQ0000QUEUEUQ0000QUUUUUQ000000TUT0000000TUUUT000000TWWWT000000TUUUT000000TUTUT000000TUTUT000";
        draw_img(u,v, playerSprite);
    }
    else{
        char playerBoatSprite[122] = "OOOOOOOOOOOOOOODDDOOOOOOODDDDDOOOOODDDDDDDOOOODUUUUUDOOOODUEUEUDOOOODUUUUUDOOOODDDDDDDOOOODDDDDDDOOOODDDDDDDOOOOOOOOOOOOO";
        draw_img(u,v, playerBoatSprite);
    }
}

#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define DIRT   BROWN
//MYCODE
#define PHAIR  0x663F04
#define DGREEN 0x384236
#define PCOAT  0xF7C6C6
#define PSKIN  0xFF9900
#define WGRAY  0xC9C9C9
#define PINK   0xE009EB
#define LBWTR  0x00C4FF
#define DBWTR  0x0C667D
#define RGRAY  0x242424



//MYCODE

void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        else if (img[i] == '5') colors[i] = LGREY;
        else if (img[i] == '3') colors[i] = DGREY;
        //MYCODE
        //Player colors
        else if (img[i] == 'Q') colors[i] = PHAIR;
        else if (img[i] == 'E') colors[i] = DGREEN;
        else if (img[i] == 'W') colors[i] = WHITE;
        else if (img[i] == 'T') colors[i] = PCOAT;
        else if (img[i] == 'U') colors[i] = PSKIN;
        
        //WALL
        else if (img[i] == 'I') colors[i] = WGRAY;
        //NPC
        else if (img[i] == 'A') colors[i] = PINK;
        //WATER
        else if (img[i] == 'O') colors[i] = LBWTR;
        else if (img[i] == 'P') colors[i] = DBWTR;
        //ROCKS
        else if (img[i] == 'S') colors[i] = RGRAY;
        //ENDMYCODE
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_nothing(int u, int v)
{
    // Fill a tile with blackness
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_expPnt(int u, int v){
    char expPntSprite[122] = "00YYYYYYY00000YYYYY000000YYYYY000000YYYYY0000000YYY00000000YYY00000000YYY00000000000000000000Y000000000YYY000000000Y00000";
    draw_img(u,v, expPntSprite);
}

void draw_wall(int u, int v)
{
    //OGCODE
    //uLCD.filled_rectangle(u, v, u+10, v+10, BROWN);
    
    //MYCODE
    char wallSprite[122] = "IIIIIIIIIIIWWIIWWWIIWWIIWWIIIWWIIIIIIIIIIIIIWWWWWWWWWWWIIIIIIIIIIIWWWWWWWWWWWIIIIIIIIIIIIIWWIIIWWIIWWIIWWWIIWWIIIIIIIIIII";
    draw_img(u,v, wallSprite);
}

void draw_plant(int u, int v)
{
    //OGCODE
    //uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    char plantSprite[122] = "00000G000000000GGG0000000GGGGG00000GGGGGGG000GGGGGGGGG00GGGGGGGGG0GGGGGGGGGGG0000DDD00000000DDD00000000DDD00000000DDD0000";
    draw_img(u,v, plantSprite);  
}

//MYCODE
void draw_NPC(int u, int v)
{
    //uLCD.filled_rectangle(u,v,u+10,v+10, YELLOW); 
    char NPCSprite[122] = "00000000000000GGGGG00000GGGGGGG000GGAGGGAGG00GGAGGGAGG00GGGGGGGGG00GGGGGGGGG00GGAGGGAGG000GGAAAGG00000GGGGG00000000000000";
    draw_img(u,v, NPCSprite);     
}

void draw_ladder(int u, int v){
    
    char ladderSprite[122] = "II0000000IIIIIIIIIIIIIII0000000IIIIIIIIIIIIIII0000000IIIIIIIIIIIIIII0000000IIIIIIIIIIIIIII0000000IIIIIIIIIIIIIII0000000II";
    draw_img(u,v, ladderSprite);   
}

void draw_key(int u, int v){
    char keySprite[122] = "000YYYYY0000YYYYYYYY000YYYYYYYY000YYYYYYYY00000YYYYY00000000Y0000000000Y0000000YYYY0000000000Y0000000YYYY0000000000Y00000";
    draw_img(u,v,keySprite);   
}

void draw_sonar(int u, int v){
    char sonarSprite[122] = "00GGGGGGG000G0000000G0G000000000G00GGGGGGG000G0000000G00000GGG0000000G000G0000000000000000000Y000000000YYY0000000YYYYY000";
    draw_img(u,v,sonarSprite);   
}

void draw_treasure(int u, int v){
    char treasureSprite[122] = "000000000000YYDDDDDYY0YDDDDDDDDDYYDDDYYYDDDYIIIIYIYIIIIDDDDYYYDDDDDDDDDDDDDDDDDDDDDDDDDDIDDDDDDDDDIIIDDDDDDDII00000000000";
    draw_img(u,v,treasureSprite);   
}

void draw_water(int u, int v){
    char waterSprite[122] = "OOOOOOOOOOOOOOPOOOPOOOOOOPOOOPOOOOOPPOOPPOOOOOPOOOPOOOOOOPOOOPOOOOOOOOPOOOPOOOOOOPOOOPOOOOOPPOOPPOOOOOPOOOPOOOOOOOOOOOOOO";
    draw_img(u,v,waterSprite);  
}

//sparkle1
void draw_waterS1(int u, int v){
    char waterS1Sprite[122] = "OOOOOOOOOOOOOOYOOOPOOOOOYYYOOPOOOOOPYOOPPOOOOOPOOOPOOOOOOPOOOPOOOOOOOOPOOOPOOOOOOPOYOPOOOOOPPOOPPOOOOOPOOOPOOOOOOOOOOOOOO";
    draw_img(u,v,waterS1Sprite);  
}

void draw_waterS2(int u, int v){
    char waterS2Sprite[122] = "OOOOOOOOOOOOOOOOOOPOOOOOOYOOOPOOOOOPOOOPPOOOOOPOOOPOOOOOOPOOOPOOOOOOOOPOYOPOOOOOOPYYYPOOOOOPPOYPPOOOOOPOOOPOOOOOOOOOOOOOO";
    draw_img(u,v,waterS2Sprite);  
}

void draw_rock(int u, int v){
    char rockSprite[122] = "00000000000000ISSI000000ISSIII0000IISIIIIS00ISIIIIISSI0ISIIIIISIISIISIISISIISISIIISIISSISSIISIISSISSIIISIISIIS0IIISSSIIII";
    draw_img(u,v,rockSprite);  
}



void draw_gate(int u, int v){
    char gateSprite[122] = "00000000000000YYYYY000000YY0YY000000Y000Y000YYYY000YYYYYYYYY0YYYYYYYYYY0YYYYY000Y000Y000000YY0YY000000YYYYY00000000000000";
    draw_img(u,v,gateSprite);  
}

void draw_prisoner(int u, int v){
    char prisonerSprite[122] = "IIIIIIIIIIIIWWPWWWPWWIIIIPIIIPIIIIWWPWWWPWWIIIIIIIIIIIIIWWWWWWWWWIIIIIIIIIIIIIWWPPPPPWWIIIIPPPPPIIIIWWWWWWWWWIIIIIIIIIIII";
    draw_img(u,v,prisonerSprite);  
}

//"IIIIIIIIIIIIWWPWWWPWWIIIIPIIIPIIIIWWPWWWPWWIIIIIIIIIIIIIWWWWWWWWWIIIIIIIIIIIIIWWPPPPPWWIIIIPPPPPIIIIWWWWWWWWWIIIIIIIIIIII";

void draw_wood(int u, int v)
{
    // Fill a tile with blackness
    uLCD.filled_rectangle(u, v, u+10, v+10, BROWN);
}

void draw_upper_status(int playerX, int playerY)
{
    // Draw bottom border of status bar
    uLCD.line(0, 9, 127, 9, GREEN);
    
    // Add other status info drawing code here
    
    //MYCODE
    uLCD.locate(1,0);
    uLCD.printf("(%d, %d)", playerX, playerY);
    
    
    
}

void draw_lower_status()
{
    // Draw top border of status bar
    uLCD.line(0, 118, 127, 118, GREEN);
    
    // Add other status info drawing code here
}

void draw_border()
{
    uLCD.filled_rectangle(0,     9, 127,  14, WHITE); // Top
    uLCD.filled_rectangle(0,    13,   2, 114, WHITE); // Left
    uLCD.filled_rectangle(0,   114, 127, 117, WHITE); // Bottom
    uLCD.filled_rectangle(124,  14, 127, 117, WHITE); // Right
}


