#ifndef TIMEHELP_H
#define TIMEHELP_H

#include <stdlib.h>
#include <string>

// return true is seconds is even, false if not
// currTime is in the form HH:MM:SS.s
bool secondsAreEven(char currTime[]) {
    char seconds[3];
    seconds[0] = currTime[6];
    seconds[1] = currTime[7];
    seconds[2] = 0;
    
    int secondsInt = atoi(seconds);
    
    return (secondsInt % 2) == 0;
}

// given a starting time (starttime) in the form HH:MM:SS.s
// and a number of seconds (secsToAdd), add the seconds to that
// time and put the resulting string into resultTime ... both
// startTime and resultTime must be character arrays of length 10
void addSecondsToCurrentTime(char startTime[], char resultTime[], float secsToAdd) {

    int decsToAdd=0,newSecsToAdd=0,minutesToAdd=0,hoursToAdd=0;
    
    // if there are enough seconds to add, that an hour
    // if being added, then do that and subtract what you added
    if ((int)secsToAdd / 3600 > 0) {
        hoursToAdd = (int)(secsToAdd / 3600);
        secsToAdd -= hoursToAdd * 3600;
    }
    
    // there may be minutes to add if there are enough seconds
    if ((int)secsToAdd / 60 > 0) {
        minutesToAdd = (int)(secsToAdd / 60);
        secsToAdd -= minutesToAdd * 60;   
    }
    
    if ((int)secsToAdd > 0) {
        newSecsToAdd = (int)secsToAdd;
        secsToAdd -= newSecsToAdd;
    }
    
    decsToAdd = (int)(secsToAdd * 10);

    // now we have to add them to currTime one at a time
    // becausse if any of the currTime slots become more
    // than 10/60/60 then we have to add them to the next
    // highest interval
    
    // decimal
    char prevDecimal[2];
    prevDecimal[1] = 0;
    prevDecimal[0] = startTime[9];
    int newDecimal = atoi(prevDecimal) + decsToAdd;
    
    if (newDecimal >= 10) {
        newSecsToAdd++;
        newDecimal = newDecimal % 10;
    }
    
    // seconds
    char prevSeconds[3];
    prevSeconds[0] = startTime[6];
    prevSeconds[1] = startTime[7];
    prevSeconds[2] = 0;
    int newSeconds = atoi(prevSeconds) + newSecsToAdd;
    
    if (newSeconds >= 60) {
        minutesToAdd++;
        newSeconds = newSeconds % 60;
    }

    // minutes
    char prevMinutes[3];
    prevMinutes[0] = startTime[3];
    prevMinutes[1] = startTime[4];
    prevMinutes[2] = 0;
    int newMinutes = atoi(prevMinutes) + minutesToAdd;
    
    if (newMinutes >= 60) {
        hoursToAdd++;
        newMinutes = newMinutes % 60;
    }
    
    // hours
    char prevHours[3];
    prevHours[2] = 0;
    prevHours[0] = startTime[0];
    prevHours[1] = startTime[1];
    int newHours = atoi(prevHours) + hoursToAdd;
    newHours = newHours % 12;
    
    // no 00 o'clock, only 1 through 12
    if (newHours == 0) {
        newHours = 12;
    }
    
    // now we have newDecimal, newSeconds, newMinutes, and newHours
    // so we need to build up the string again
    sprintf(resultTime, "%02d:%02d:%02d.%d",newHours,newMinutes,newSeconds,newDecimal);
}

// given the current time in the form HH:MM:SS.S
// give me back the number of seconds from 00:00:00.0
// at that time
float currTimeSecs(char currentTime[]) {
    // hours
    char hours[3];
    hours[2] = 0;
    hours[0] = currentTime[0];
    hours[1] = currentTime[1];
    
    // minutes
    char minutes[3];
    minutes[0] = currentTime[3];
    minutes[1] = currentTime[4];
    minutes[2] = 0;
    
    // seconds
    char seconds[3];
    seconds[0] = currentTime[6];
    seconds[1] = currentTime[7];
    seconds[2] = 0;
    
    // decimal
    char decimal[2];
    decimal[1] = 0;
    decimal[0] = currentTime[9];
    
    return (atoi(hours)%12)*360.0 + (atoi(minutes)%60)*60.0 + (atoi(seconds)%60)*1.0 + (atoi(decimal)%10)*.1;
}

#endif