/* mbed EM-406 GPS Module Library
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include <string> 
#include "nmea.h"
#include "GPSISR.h"

NMEA nmea; //parse GPS Sentence.

GPS::GPS(PinName tx, PinName rx, int Baud) : _gps(tx, rx) {
    _gps.baud(Baud);
    _gps.attach(this,&GPS::Rx_interrupt, Serial::RxIrq);
    
    printf("Interrupt Attached");
}

void GPS::getline() {
    while(_gps.getc() != '$');    // wait for the start of a line
    for(int i=0; i<256; i++) {
        msg[i] = _gps.getc();
        if(msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
    error("Overflowed message limit");
    return;
}

// Interupt Routine to read in data from serial port
void GPS::Rx_interrupt(void) {
    interrupt = 1;
    rx_in = _gps.getc();
    nmea.fusedata(rx_in);
    interrupt = 0;
    return;
}
 bool GPS::dataready(void){
 return  nmea.isdataready();
     
}     

void GPS::read(void) {
    
    buffer.hours = nmea.getHour();
    buffer.minutes = nmea.getMinute();
    buffer.seconds = nmea.getSecond();
    buffer.day = nmea.getDay();
    buffer.month = nmea.getMonth();
    buffer.year = nmea.getYear();
    buffer.latitude = 0.0;
    buffer.longitude = 0.0;

    if (nmea.isdataready()) {
        buffer.latitude = nmea.getLatitude();
        buffer.longitude = nmea.getLongitude();
        buffer.speed = nmea.getSpeed();
        buffer.altitude = nmea.getAltitude();
        buffer.bearing = nmea.getBearing();
        buffer.satellites = nmea.getSatellites();
    }
}