/*
    File:       nav.h
    Version:    0.1.0
    Date:       Feb. 28, 2017
    License:    GPL v2
    
    Navigation class
    
    ****************************************************************************
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ****************************************************************************
 */
class NAV {
    #define PI  3.14159265358979f
    #define point_proximity_radius 10
    #define NMEA_EARTH_FLATTENING       (1 / 298.257223563)             /**< Earth's flattening according WGS 84 */
    #define NMEA_EARTH_SEMIMAJORAXIS_M  (6378137.0)                     /**< Earth's semi-major axis in m according WGS84 */
    #define NMEA_EARTH_SEMIMAJORAXIS_KM (NMEA_EARTH_SEMIMAJORAXIS_M / 1000) /**< Earth's semi-major axis in km according WGS 84 */


    private:
    // Convert Degrees to Radians
    double DegreeToRadian(double angle);
    // Convert Radians to Degrees
    double RadianToDegree(double angle);
    
    public:
    // Calculate the heading
    double CalculateDistance (double latitude1, double longitude1, double latitude2, double longitude2);
    // Calculate bearing
    double CalculateBearing(double latitude1, double longitude1, double latitude2, double longitude2);
    /*
        This function takes as input the next gps coordinate that the boat is suppossed to achieve and calculates the compass
        heading to the waypoint
        Jeff Witten - 05/26/14 from Github VT-SailBOT/Navigation sailbot.c
    */
    int direction_to_next_point (double latitude, double longitude, double next_latitude, double next_longitude);
    /*
        This function takes as input the gps coordinates of the boat and the gps coordinates of a waypoint that the boat desires to approach
        The function then sets a flag based on whether or not the boat is within a predetermined perimeter of the waypoint
        Approach:
        1.) Latitude and Longitude of San Francisco = 37.7844 N, 122.4167 W
        2.) At 40 degrees North: 1 degree latitude = 111.03 km, 1 degree longitude = 85.39 km
        3.) 111.03 = 85.39 * (1.30027) - used to correct approximately rectangular lat/lon grid to approximately square
        4.) Through unit analysis, 1 meter = 0.0000111509 degrees longitude 
        Jeff Witten - 03/27/14 from Github VT-SailBOT/Navigation sailbot.c
        */
    int point_proximity(double boat_latitude, double boat_longitude, double next_latitude, double next_longitude);
    
    double distance_ellipsoid(double from_lat,  double from_lon, double from_azimuth, double to_lat, double to_lon, double to_azimuth);
    
    int distance;
    
   };