/* mbed EM-406 GPS Module Library
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"

#ifndef MBED_GPS_H
#define MBED_GPS_H

/**  A GPS interface for reading from a Globalsat EM-406 GPS Module */
class GPS {
public:

    /** Create the GPS interface, connected to the specified serial port
     */    
    GPS(PinName tx, PinName rx, int Baud);
    //Peripheral
    Serial _gps;
    
    // Setup a serial interrupt function to transmit data
    void getline();
    void Rx_interrupt(void);
    bool dataready(void);
    
    
    //void f1(a_struct& struct);
    //f1(a_struct s);
    // Reading struct that includes the data for each reading we take
struct reading {
    float latitude;     //Signed positive if N, negative if S
    float longitude;    //Signed positive if E, negative if W
    char  latc;
    char  lonc;
    uint8_t day;
    uint8_t month;
    uint8_t year;
    uint8_t hours;
    uint8_t minutes;
    uint8_t seconds;
    float   speed;
    float   altitude;
    float   bearing;
    int     satellites;
};
struct reading buffer; 

void read(void);
    char msg[256];
    volatile char rx_in;
    bool interrupt;
private:
    
 };

#endif
