/* mbed library for touchscreen connected to 4 mbed pins
 * derive from SPI_TFT lib
 * Copyright (c) 2011 Peter Drescher - DC2PD
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MBED_TOUCH_H
#define MBED_TOUCH_H

#include "mbed.h"

#define __PRESURE 1000
#define __NOPRESURE 500
#define RXPLATE   300

//Measured ADC values for (0,0) and (210-1,320-1)
//TS_MINX corresponds to ADC value when X = 0
//TS_MINY corresponds to ADC value when Y = 0
//TS_MAXX corresponds to ADC value when X = 240 -1
//TS_MAXY corresponds to ADC value when Y = 320 -1

#define TS_MINX 10500  //116*2
#define TS_MAXX 116252 //890*2
#define TS_MINY 12500  //83*2
#define TS_MAXY 116044 //913*2

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0

struct point {
    int x;
    int y;
    int z;
};

class TouchScreen {
   public:  
    /** create a TFT with touch object connected to the pins:
     *
     * @param pin xp resistiv touch x+
     * @param pin xm resistiv touch x-
     * @param pin yp resistiv touch y+
     * @param pin ym resistiv touch y-
     * @param mosi,miso,sclk SPI connection to TFT
     * @param cs pin connected to CS of display
     * @param reset pin connected to RESET of display
     * based on my SPI_TFT lib
     */
    TouchScreen(PinName xp, PinName xm, PinName yp, PinName ym);
        void getTouch(point& p);
        long map(long x, long in_min, long in_max, long out_min, long out_max);
protected:
    PinName _xm;
    PinName _ym;
    PinName _xp;
    PinName _yp;
    //DigitalOut bl;

    typedef enum { YES, MAYBE, NO } TOUCH;
    int readTouch(PinName p, PinName m, PinName a, PinName i);
    int x_off,y_off;
    int pp_tx,pp_ty;
};

#endif
