/* mbed library for resistive touch pads
 * uses 4 pins - 2 IO and 2 Analog

 * c 2011 Peter Drescher - DC2PD
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "mbed.h"
#include "SeeedStudioTFTv2.h"

//Serial pc(USBTX,USBRX,19200);

TouchScreen::TouchScreen(PinName xp, PinName xm, PinName yp, PinName ym)
{
    //font = NULL;
    // touch screen pins
    _xp = xp;
    _yp = yp;
    _xm = xm;
    _ym = ym;
    // default touch calibration
    // orientation     //      0      1      2      3
    x_off = 108000;  //  17252  16605 108755 108000
    y_off =  22000;  //  22330 105819  97167  22000
    pp_tx =   -291;  //    378    289   -390   -291
    pp_ty =    356;  //    261   -355   -239    356
}

int TouchScreen::readTouch(PinName p, PinName m, PinName a, PinName i)
{
    int n, avg;
    // Setup analog ports to read X and Y touch values on display.
    DigitalOut _p(p);
    _p = 1;
    DigitalOut _m(m);
    _m = 0;
    AnalogIn   _a(a);
    AnalogIn   _i(i); // this pin has to be high Z (DigitalIn may also work)
    
    // Put averaging solution here. Take n samples then average.
    n=5000;
    for (int j=0; i<n; j++) {
        avg = avg + _a.read_u16();
    }
    avg=avg/n;
    
    wait_us(10);
    //return _a.read_u16();
    return avg;
}

void TouchScreen :: getTouch(point& p)
{
    volatile int y2 = readTouch(_xp,_xm,_yp,_ym);
    volatile int x2 = readTouch(_yp,_ym,_xp,_xm);
    volatile int y1 = readTouch(_xp,_xm,_yp,_ym);
    volatile int x1 = readTouch(_yp,_ym,_xp,_xm);
    int xd = x1 - x2;
    int yd = y1 - y2;
    xd = (xd > 0) ? xd : -xd;
    yd = (yd > 0) ? xd : -xd;
    p.y = x1 + x2;
    p.x = y1 + y2;
         
    int z1          =  _xm;
    int z2          =  _yp;
    float rtouch    =  0;

    rtouch  = z2;
    rtouch /= z1;
    rtouch -= 1;
    //Constants from origional reference. 
    //12 bit ADC
    rtouch *= (4094-p.x)/2;
    rtouch *= RXPLATE;
    rtouch /= 2048;
        p.x = map(p.x, TS_MINX, TS_MAXX, 0, 240);
        p.y = map(p.y, TS_MINY, TS_MAXY, 0, 320);
        p.z = abs(rtouch);
 }

 long TouchScreen :: map(long x, long in_min, long in_max, long out_min, long out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}
