#include "mbed.h"
#include "lvgl/lvgl.h"
#include "hal_stm_lvgl/tft/tft.h"
#include "hal_stm_lvgl/touchpad/touchpad.h"
#include "lv_demo.h"    

#define LVGL_TICK   10                              
#define TICKER_TIME 10ms                             



Ticker ticker;                                       
int PwmSlider; //variable correspondant à la valeur du slider


void lv_ticker_func()
{
    lv_tick_inc(LVGL_TICK);
}
//Déclaration des Pwm
PwmOut ledR1(D6);
PwmOut ledR2(D12);
PwmOut ledB1(D8);
PwmOut ledB2(D11);
PwmOut ledV1(D9);
PwmOut ledV2(D10);

static void slider_event_cb(lv_event_t * e);
static lv_obj_t * slider_label;
static void slider_event_cb(lv_event_t * e)

{
    lv_obj_t * slider = lv_event_get_target(e);
    char buf[8];
    lv_snprintf(buf, sizeof(buf), "%d", (int)lv_slider_get_value(slider));
    lv_label_set_text(slider_label, buf);
    PwmSlider = lv_slider_get_value(slider);
    lv_obj_align_to(slider_label, slider, LV_ALIGN_OUT_BOTTOM_MID, 0, 10);
}
//Déclaration du slider

static void btnMag_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {          //Quand le bouton est appuyé on execute le code en dessous
        ledB1.write(0.4*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0*PwmSlider/1000.0);
    }
}
//Evenement détectant l'appui du bouton (même structure pour tout les boutons)

static void btnBle_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {         
        ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(0*PwmSlider/1000.0);
        ledV1.write(0*PwmSlider/1000.0);
        

    }
}

static void btnVer_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(0*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        
      
    }
}

 static void btnJau_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0.7*PwmSlider/1000.0);
        
      
    }
}

 static void btnOra_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0.200*PwmSlider/1000.0);
        
      
    }
}

 static void btnBla_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        
      
    }
}

 static void btnRou_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0*PwmSlider/1000.0);
        
      
    }
}

 static void btnCya_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(0.2*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        
      
    }
}

 static void btnVio_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        ledB1.write(0.9*PwmSlider/1000.0);
        ledR1.write(0.6*PwmSlider/1000.0);
        ledV1.write(0.2*PwmSlider/1000.0);
        
      
    }
}

 static void btnPom_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {             
        ledB1.write(0.05*PwmSlider/1000.0);
        ledR1.write(0.5*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        
      
    }
}

 static void btnMul_event_cb(lv_event_t * e)
{
    lv_event_code_t code = lv_event_get_code(e);
    lv_obj_t * btn = lv_event_get_target(e);
    if(code == LV_EVENT_CLICKED) {
        
        ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(0*PwmSlider/1000.0);
        ledV1.write(0*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(0*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0.4*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0.7*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(0.200*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
         wait_us(1000000);
         ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(0.2*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0.05*PwmSlider/1000.0);
        ledR1.write(0.5*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(0.9*PwmSlider/1000.0);
        ledR1.write(0.6*PwmSlider/1000.0);
        ledV1.write(0.2*PwmSlider/1000.0);
        wait_us(1000000);
        ledB1.write(1*PwmSlider/1000.0);
        ledR1.write(1*PwmSlider/1000.0);
        ledV1.write(1*PwmSlider/1000.0);
        wait_us(1000000);
        
      
    }
}

// main() runs in its own thread in the OS
int main()
{
    printf("LVGL-");
    lv_init();                                              //Initialize the LVGL
    tft_init();                                             //Initialize diplay
    touchpad_init();                                        //Initialize touchpad
    ticker.attach(callback(&lv_ticker_func),TICKER_TIME);   //Attach callback to ticker
    
    lv_obj_t * slider = lv_slider_create(lv_scr_act());     //Création du slider au milieu de l'écran
    lv_slider_set_range(slider,0,1000);
    lv_slider_set_value(slider, 1000, LV_ANIM_ON);
    lv_obj_center(slider);
    lv_obj_add_event_cb(slider, slider_event_cb, LV_EVENT_VALUE_CHANGED, NULL);
    /*Create a label below the slider*/
    slider_label = lv_label_create(lv_scr_act());
    lv_label_set_text(slider_label, "1000");
    lv_obj_align_to(slider_label, slider, LV_ALIGN_OUT_BOTTOM_MID, 0, 10);
     
    lv_obj_t * btnMag = lv_btn_create(lv_scr_act());     //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnMag, 10, 10);                            //Position du bouton
    lv_obj_set_size(btnMag, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnMag, btnMag_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelMag = lv_label_create(btnMag);          //Ajoute un label au bouton
    lv_label_set_text(labelMag, "Magenta");                     //Texte du label donc du bouton
    lv_obj_center(labelMag);
    
    lv_obj_t * btnBle = lv_btn_create(lv_scr_act());    //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnBle, 130, 10);                            //Position du bouton
    lv_obj_set_size(btnBle, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnBle, btnBle_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelBle = lv_label_create(btnBle);          //Ajoute un label au bouton
    lv_label_set_text(labelBle, "Bleu");                     //Texte du label donc du bouton
    lv_obj_center(labelBle);
    
    lv_obj_t * btnVer = lv_btn_create(lv_scr_act());    //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnVer, 250, 10);                            //Position du bouton
    lv_obj_set_size(btnVer, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnVer, btnVer_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelVer = lv_label_create(btnVer);          //Ajoute un label au bouton
    lv_label_set_text(labelVer, "Vert");                     //Texte du label donc du bouton
    lv_obj_center(labelVer);
    
    lv_obj_t * btnJau = lv_btn_create(lv_scr_act());     //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnJau, 370, 10);                            //Position du bouton
    lv_obj_set_size(btnJau, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnJau, btnJau_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelJau = lv_label_create(btnJau);          //Ajoute un label au bouton
    lv_label_set_text(labelJau, "Jaune");                     //Texte du label donc du bouton
    lv_obj_center(labelJau);
    
    lv_obj_t * btnOra = lv_btn_create(lv_scr_act());    //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnOra, 10, 100);                            //Position du bouton
    lv_obj_set_size(btnOra, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnOra, btnOra_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelOra = lv_label_create(btnOra);          //Ajoute un label au bouton
    lv_label_set_text(labelOra, "Orange");                     //Texte du label donc du bouton
    lv_obj_center(labelOra);
    
    lv_obj_t * btnBla = lv_btn_create(lv_scr_act());    //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnBla, 10, 200);                            //Position du bouton
    lv_obj_set_size(btnBla, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnBla, btnBla_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelBla = lv_label_create(btnBla);          //Ajoute un label au bouton
    lv_label_set_text(labelBla, "Blanc");                     //Texte du label donc du bouton
    lv_obj_center(labelBla);
    
    lv_obj_t * btnRou = lv_btn_create(lv_scr_act());    //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnRou, 130, 200);                            //Position du bouton
    lv_obj_set_size(btnRou, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnRou, btnRou_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelRou = lv_label_create(btnRou);          //Ajoute un label au bouton
    lv_label_set_text(labelRou, "Rouge");                     //Texte du label donc du bouton
    lv_obj_center(labelRou);
    
    lv_obj_t * btnCya = lv_btn_create(lv_scr_act());     //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnCya, 250, 200);                            //Position du bouton
    lv_obj_set_size(btnCya, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnCya, btnCya_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelCya = lv_label_create(btnCya);          //Ajoute un label au bouton
    lv_label_set_text(labelCya, "Cyan");                     //Texte du label donc du bouton
    lv_obj_center(labelCya);
    
    lv_obj_t * btnVio = lv_btn_create(lv_scr_act());     //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnVio, 370, 200);                            //Position du bouton
    lv_obj_set_size(btnVio, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnVio, btnVio_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelVio = lv_label_create(btnVio);          //Ajoute un label au bouton
    lv_label_set_text(labelVio, "Violet");                     //Texte du label donc du bouton
    lv_obj_center(labelVio);
    
    lv_obj_t * btnPom = lv_btn_create(lv_scr_act());     //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnPom, 370, 100);                            //Position du bouton
    lv_obj_set_size(btnPom, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnPom, btnPom_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelPom = lv_label_create(btnPom);          //Ajoute un label au bouton
    lv_label_set_text(labelPom, "Pomme");                     //Texte du label donc du bouton
    lv_obj_center(labelPom);
    
    lv_obj_t * btnMul = lv_btn_create(lv_scr_act());    //Ajoute un bouton à l'écran
    lv_obj_set_pos(btnMul, 500, 10);                            //Position du bouton
    lv_obj_set_size(btnMul, 120, 50);                          //Taille du bouton
    lv_obj_add_event_cb(btnMul, btnMul_event_cb, LV_EVENT_ALL, NULL);           
    lv_obj_t * labelMul = lv_label_create(btnMul);          //Ajoute un label au bouton
    lv_label_set_text(labelMul, "Multi");                     //Texte du label donc du bouton
    lv_obj_center(labelMul);
    
    //Déclaration des périodes des LEDs
    ledR1.period_us(500);
    ledR2.period_us(500);
    ledB1.period_us(500);
    ledB2.period_us(500);
    ledV1.period_us(500);
    ledV2.period_us(500);

    while(1) {
        
        lv_task_handler();

        thread_sleep_for(LVGL_TICK);
        printf("%d\r\n", lv_slider_get_value(slider));

    }
}
