#include "TwitPic.h"

#define IMAGE_PATH "/local/image.jpg"

//get an api key from twit.pic, put it below
const char twitpic_api_key[]    = "PUT_YOUR_TWITPIC_API_KEY_HERE"; 


//twitter has a lot more keys you need. get all those and enter them below.
const char consumer_key[]        = "PUT_YOUR CONSUMER_KEY_HERE";  
const char consumer_secret[]     = "PUT_YOUR_CONSUMER_SECRET_HERE"; 


const char access_token[]        = "PUT_YOUR_ACCESS_TOKEN_HERE"; 
const char access_token_secret[] = "ACCESS_TOKEN_SECRET_HERE"; 

int main() {
    TwitPic twitpic(twitpic_api_key,consumer_key,consumer_secret,access_token,access_token_secret);  
    LocalFileSystem local("local");
    EthernetNetIf network;
    
    
    printf("Setting up network...\n");
    EthernetErr ethErr = network.setup();
    if (ethErr) {
        printf("Error %d in network setup.\n", ethErr);
        return -1;
    }
    printf("Network Setup OK\n");

    printf("Opening File...\n");
    FILE *img = fopen(IMAGE_PATH, "r");
    if (img == NULL) {
        printf("Error in file open.\n");
        return -1;
    }
    printf("File open.\n");
   
    int ret = twitpic.uploadAndPost("What the what?", img);
    if (ret < 0) {
        printf("Twitpic upload failed with error %i",ret);
        return ret;
    }
    return 0;
}