/*
  TwitPic.h - TwitPic Image Uploader for mbed
  Copyright (c) novachild 2011. All rights reserved.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  
  REQUIRES: EthernetNetIf, DNSResolver, some sort of file access (SD, local, etc)

*/

#ifndef TwitPic_h
#define TwitPic_h

#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "host.h"
#include "ipaddr.h"
#include "dnsresolve.h"

class TwitPic {
public:
    TwitPic(const char *twitpic_api_key, const char *consumer_key, const char *consumer_secret, const char *access_token, const char *access_token_secret);
    int upload(const char *message,
               FILE *img,
               bool toPost = false);

    int uploadAndPost(const char *message,
                      FILE *imgFile);

private:
    Host server;
    TCPSocket socket;
    
    
    void handleTCPSocketEvents(TCPSocketEvent ev);

    void sendHeaders();
    void sendParameters();
    void sendImageData();
    void sendFooter();
    void sendNextChunk();
    
    void getResponse();
    void flushResponse();

};


#endif
