#pragma once
#include "mbed.h"
#include "genData.h"

genData::genData(){
    p_hysteresis = false;
    p_hysteresisInterval = 0;
    p_lowerRateLimit = 0;
    p_upperRateLimit = 0;
    p_AVdelay = 0;
    p_AVdelayOffset = 0;
    p_rateSmoothing = 0;
    p_pacingMode = VVI;
    p_pacingState = PERMANENT;
}

void genData::chngHyst(bool chng){
    p_hysteresis = chng;   
}

bool genData::getHyst(){
    return p_hysteresis;   
}

void genData::chngHystInterval(double val){
    p_hysteresisInterval = val;   
}

double genData::getHystInterval(){
    return p_hysteresisInterval;
}

void genData::chngLRL(double val){
    p_lowerRateLimit = val;   
}

double genData::getLRL(){
    return p_lowerRateLimit;
}

void genData::chngURL(double val){
    p_upperRateLimit = val;
}

double genData::getURL(){
    return p_upperRateLimit;
}

void genData::chngAVdelay(double val){
    p_AVdelay = val;
}

double genData::getAVdelay(){
    return p_AVdelay;   
}

void genData::chngAVdelayOffset(double val){
    p_AVdelayOffset = val;   
}

double genData::getAVdelayOffset(){
    return p_AVdelayOffset;
}

void genData::chngRSmooth(double val){
    p_rateSmoothing = val;   
}

double genData::getRSmooth(){
    return p_rateSmoothing;   
}

void genData::chngMode(Mode mode){
    p_pacingMode = mode;
}

genData::Mode genData::getMode(){
    return p_pacingMode;
}

void genData::chngState(State state){
    p_pacingState = state;
}

genData::State genData::getState(){
    return p_pacingState;
}



genData::~genData(){}