#pragma once
#include "mbed.h"
#include "interface.h"
#include "hardware.h"
#include "chamberData.h"
#include "genData.h"
#include "pulse.h"
#include "voor.h"
#include <stdlib.h>
#include <stdio.h>
#include <string>

//CONSTRUCTORS*****************************
interface::interface(){
    }

interface::~interface(){};

interface::interface(Serial* inputPC){
    pc = inputPC;
    }

interface::interface(Serial* inputPC , pulse* p , chamberData* atrium , chamberData* ventricle){
    pc = inputPC;
    interfacePulse = p;
    atrData = atrium;
    ventData = ventricle;
    startScreen();
    }
//********************************************


//USER INTERFACE SCREENS**************************   

void interface::startScreen(){
    (*pc).printf("\nWelcome to the PACEMAKER DCM.\n");
    (*pc).printf("Options:\n");
    (*pc).printf("1. Start VOOR Pulse\n"); // temporary test to get VOOR working
    (*pc).printf("2. View/Change data\n");
    (*pc).printf("Please enter a command:");
    char command = getChar();
    switch (command) {
        case '1':{
            voor v(interfacePulse); //creates new instance of voor
            v.startPace(); //starts pacing voor the same way as it used to pace in the user interface
            //interfacePulse->startPulse(); //problems with this method: you create the pc output twice, once in UI and once in pulse.
            startScreen();                             //realistically we'll never need to call the serial output in pulse, it should all be done in UI
            break;
            }
        case '2':
            interface::dataScreen();
            break;
        default:
            pc->printf("\nThat is not an option.");
            interface::startScreen();
            break;
    }   
}

void interface::dataScreen(){
    (*pc).printf("\nDCM Data sets:\n");
    (*pc).printf("1. Atrium Data\n2. Ventricle Data\n3. General Data\n4. Egram Data\n5. Back to start page\n");
    (*pc).printf("Choose a data set:");
    char command = getChar();
    switch (command) {
        case '1':
            pc->printf("\nAtrium Data");
            pc->printf("\n1. Pace Amplitude: %f", atrData->getPaceAmp()*7);
            pc->printf("\n2. Pace Width: %f", atrData->getPaceWidth());
            pc->printf("\n3. Refractory Period: %f", atrData->getRP());
            pc->printf("\n4. Sensitivity: %f", atrData->getSensitivity());
            pc->printf("\nChoose variable to be changed or 5 To return to Data Sets");
            interface::getData(atrData);
            break;
        case '2':
            pc->printf("\nVentricle Data");
            pc->printf("\n1. Pace Amplitude: %f", ventData->getPaceAmp()*7);
            pc->printf("\n2. Pace Width: %f", ventData->getPaceWidth());
            pc->printf("\n3. Refractory Period: %f", ventData->getRP());
            pc->printf("\n4. Sensitivity: %f", ventData->getSensitivity());
            pc->printf("\nChoose variable to be changed or 5 To return to Data Sets");
            interface::getData(ventData);
            break;
        case '3':
            pc->printf("\nGeneral Data");
//            pc->printf("\n1. Hysteresis: %f",
        case '4':
            pc->printf("\nNot setup yet");
            break;
        case '5':
            interface::startScreen();  
        default:
            pc->printf("\nThat is not an option.");
            interface::dataScreen();
    }  
}

void interface::getData(chamberData* chamber){
    char command = getChar();
    switch (command){
        case '1':
            pc->printf("\nChoose New Value:");
            char* value = getInput();
            chamber->chngPaceAmp(atof(value));
            pc->printf("\t%f",chamber->getPaceAmp()*7);
            interface::dataScreen();
            break;
        case '2':
            pc->printf("\nChoose New Value:");
            value = getInput();
            chamber->chngPaceWidth(atof(value));
            pc->printf("\t%f",chamber->getPaceWidth());
            interface::dataScreen();
            break;
        case '3':
            pc->printf("\nChoose New Value:");
            value = getInput();
            chamber->chngRP(atof(value));
            pc->printf("\t%f",chamber->getRP());
            interface::dataScreen();
            break;
        case '4':
            pc->printf("\nChoose New Value:");
            value = getInput();
            chamber->chngSensitivity(atof(value));
            pc->printf("\t%f",chamber->getSensitivity());
            interface::dataScreen();
            break;
        case '5':
            interface::dataScreen();
            break;
        default:
            pc->printf("\nThat is not an option.");
            interface::getData(chamber);
    }  
 }
 
char* interface::getInput(){
    char buffer[5];
    fgets (buffer,5,stdin);
    return buffer;
}

char interface::getChar(){
    while(true){
        if(pc->readable()){
            char command = pc->getc();
            return command;   
            }   
        }   
}
//****************************

//void interface::getAPulse(){ //TODO get this to work, the wait command has issues, see pulse.cpp . wait takes in seconds as argument
//    pulse myPulse(*atr);
//    myPulse.setWidth(1);
//    myPulse.startPulse();
//    }
    
//void interface::LEDon(AnalogOut* out){
//    (*out) = 0;
////    (*pc).printf(led);
//}
//    
//void interface::LEDoff(AnalogOut* out){
//    (*out) = 1;
//}