#pragma once
#include "mbed.h"
#include "pulse.h"

pulse::pulse(){}
    
pulse::pulse(chamberData* chamber, hardware* IOpins){
    myIOpins = IOpins;
    myChamber = chamber;
//    myPaceWidth = 0; //mSec, width of ventricular pace
//    myPaceAmp = 0; //mV, amplitude of ventricular pace
//    myRP = 0; //mSec, duration of refractory period
//    p_hysteresisInterval = 0;
//    p_lowrateInterval = 0;
//    p_hysteresis = false;
    
}

pulse::~pulse(){
    delete myChamber;
    delete myIOpins;
    delete pc;
    delete aOut;
}

void pulse::setChamber(chamberData* c){
    myChamber = c;
    }
      

void pulse::startPulse(){
   // while(true){
        pc = myIOpins->getSerial();  
        aOut = myIOpins->getChamber(myChamber->getChamberType());
        aOut->write(myChamber->getPaceAmp());    
        wait(myChamber->getPaceWidth());
        aOut->write(0);
        
        pc->printf("\nPulsing...check your oscilloscope!");
       // wait(myChamber->getPaceWidth());
        
       // }
}
    