#pragma once
#include "mbed.h"

class genData{
public:
    enum Mode
    {
        VVI,
        VOOR 
    };
    enum State
    {
        PERMANENT,
        TEMPORARY
    };
    
    genData();
    ~genData();
    void chngHyst(bool);
    bool getHyst();
    void chngHystInterval(double);
    double getHystInterval();
    void chngLRL(double);
    double getLRL();
    void chngURL(double);
    double getURL();
    void chngAVdelay(double);
    double getAVdelay();
    void chngAVdelayOffset(double);
    double getAVdelayOffset();
    void chngRSmooth(double);
    double getRSmooth();
    virtual void chngMode(Mode mode);
    virtual Mode getMode();
    virtual void chngState(State state);
    virtual State getState();
    //virtual bool isMagnet();
    //virtual void chngMagnet(bool state);

protected:
    double p_hysteresis;
    double p_hysteresisInterval;
    double p_lowerRateLimit;
    double p_upperRateLimit;
    double p_AVdelay;
    double p_AVdelayOffset;
    double p_rateSmoothing;
    Mode p_pacingMode;
    State p_pacingState;
    
};