#pragma once
#include "mbed.h"
#include "chamberData.h"
#include "genData.h"
#include "pulse.h"
#include "hardware.h"
#include "interface.h"
#include "voor.h"
#include "sense.h"
#include "rtos.h"

int main(){
    hardware* io = new hardware();
    genData* generalData = new genData();
    chamberData* atrium = new chamberData(io->getSerial(),'a');
    chamberData* ventricle = new chamberData(io->getSerial(), 'v');
    pulse* ventPulse = new pulse(ventricle,io);
    pulse* atrPulse = new pulse(atrium,io);
    interface a(io->getSerial() , ventPulse , generalData, atrium , ventricle); 
    //if 
    a.startScreen();   
    
    
    delete ventricle; //code never reaches here, since we're stuck in the while loops of the pacing, user interface, etc.
    delete atrium;
    delete ventPulse;
    delete io;
    
return 0;
    }