#pragma once
#include "mbed.h"
#include "chamberData.h"

chamberData::chamberData(){
}

chamberData::chamberData(Serial* inputPC, char chamberType){
    p_PaceAmp = 3.75; //decimal value between 0 and 1 which is a factor applied to 3.3V output.  ie. 0.5 will give 0.5(3.3) V of output
    p_PaceWidth = 0.4;
    p_RP = 0;
    p_Sensitivity = 0;
    mychamber = chamberType;
    pc = inputPC;
       
}
char chamberData::getChamberType(){
    return mychamber;
}

void chamberData::chngPaceAmp(double amp){
    if(mychamber == 'a'){
        if(amp>3.2 || amp<0.5){
            pc->printf("\nThat value is not within range."); 
        }else p_PaceAmp = (amp-0)/(7-0);
    }else{
        if(amp>7 || amp<3.5){
            pc->printf("\nThat value is not within range.");
        }else p_PaceAmp = (amp-0)/(7-0);
    }
}

double chamberData::getPaceAmp(){
    return p_PaceAmp;
}

void chamberData::chngPaceWidth(double width){
    if(mychamber == 'a'){
        if(width!=0.05){pc->printf("\nThat value is not within range.");
        }else p_PaceWidth = width;
    }else{
        if(width>1.9 || width< 0.1){pc->printf("\nThat value is not within range.");
        }else p_PaceWidth = width;
    }
}

double chamberData::getPaceWidth(){
    return p_PaceWidth;
}

void chamberData::chngRP(double RP){
    if(mychamber == 'a'){
        if(RP>500 || RP<150){pc->printf("\nThat value is not within range.");
        }else p_RP = RP;
    }else{
        if(RP>500 || RP< 150){pc->printf("\nThat value is not within range.");
        }else p_RP = RP;
    }
}

double chamberData::getRP(){
    return p_RP;
}

void chamberData::chngSensitivity(double sensitivity){
   if(mychamber == 'a'){
        if(sensitivity!=0.05 || sensitivity!= 0.25 || sensitivity!=0.75){pc->printf("\nThat value is not within range.");
        }else p_Sensitivity = sensitivity;
    }else{
        if(sensitivity>10 || sensitivity< 1){pc->printf("\nThat value is not within range.");
        }else p_Sensitivity = sensitivity;
    }
}

double chamberData::getSensitivity(){
    return p_Sensitivity;
}
chamberData::~chamberData(){}