/*
int main(void)
{
    
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        rled = (1.0f - x)*2;
        gled = (1.0f - y)*2;
        bled = (1.0f - z)*2;
        wait(0.1f);
        
   //     printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
    }
}

*/


 #include "mbed.h"
 #include "USBMouse.h"
 #include <math.h>
 #include "MMA8451Q.h"
 #include "tsi_sensor.h"
 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif
 
 USBMouse mouse(ABS_MOUSE);
 
 int main(void)
 {
   int16_t x_center = (X_MAX_ABS - X_MIN_ABS)/2;
   int16_t y_center = (Y_MAX_ABS - Y_MIN_ABS)/2;

//   uint32_t x_origin = x_center;
//   uint32_t y_origin = y_center;
//   uint32_t radius = 5000;
//   uint32_t angle = 0;
 
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    int16_t x_screen = 0;
    int16_t y_screen = 0;
 TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    static int16_t x_current = x_center;
    static int16_t y_current = y_center;
    int16_t scaling = 5000;
    float prevX=0U;
    float prevY=0U;
   while (1)
   {
    //     x_screen = x_origin + static_cast<int16_t>(10*x_screen);
   //    y_screen = y_origin + sin((double)angle*3.14/180.0)*radius;
        float currX=acc.getAccX();
        float currY=acc.getAccY();
        float diffY=prevY-currY;
        float diffX=prevX-currX;
        const float threshold = .08;
        if(diffY<threshold && diffY>-threshold){x_screen=0;}
        else{x_screen = -(scaling*(acc.getAccY()));}
        if(diffX<threshold && diffX>-threshold){y_screen=0;}
        else{y_screen =  (scaling*(acc.getAccX()));}
        prevX = currX;
        prevY = currY;
    //-.5f));
       //y_screen = (50*(acc.getAccX()));///-.5f));
        printf("DIFF_X: %f :: DIFF_Y: %f\t",diffX,diffY);
    
    //x_current =x_current+(x_screen%X_MAX_ABS);
    x_current+=x_screen;
    y_current+=y_screen;
    //x_current = x_screen%X_MAX_ABS + x_center;
    //y_current = y_screen%Y_MAX_ABS + y_center;
    //y_current =y_current+(y_screen%Y_MAX_ABS);
    //printf("X = %d   Y = %d   \n", x_current, y_current);
    printf("X = %f   Y = %f   Z = %f \n\r", acc.getAccX(), acc.getAccY(), acc.getAccZ());
    //wait(0.1f);
    mouse.move(x_current, y_current);
    float slider= tsi.readPercentage();
    if(slider>.05f && slider < .5f){mouse.click(MOUSE_RIGHT);}
    else if(slider>.5f){mouse.click(MOUSE_LEFT);} 
 //       mouse.move(static_cast<int16_t>(10*x_screen), static_cast<int16_t>(10*y_screen));
       //angle += 3;
       //wait(0.05);
   }
 }

