/*
 * Adafruit NeoPixel 8x8 matrix example
 *
 * This program demonstrates the functions from the NeoArray library by creating sample patterns on a NeoPixel NeoMatrix 8x8 array
 *
 */

#include "mbed.h"
#include "NeoMatrix.h"

#define Color(r, g, b)  ((r&0xFF)<<16 | (g&0xFF) << 8 | (b&0xFF))   // pack colors

#define Red     (Color(255,0,0))
#define Green   (Color(0,255,0))
#define Blue    (Color(0,0,255))

NeoArr array(p18, 1);   // Initialize the array

int main()
{
    
    float bright = 0.2; // 20% is bright enough for most indoor use and should run without need for external power

    array.setBrightness(bright);    // set brightness to default 0.2
    array.clear();
    
    while (true)
    {
        // Horrizontal scroll x y z
        for(char c = 'x'; c <= 'z'; c++)
            for(int i=7;i>=-6;i--){
                array.clear();
                array.drawChar(0,i,0,c, 255,255,255);
                array.write();
                wait_ms(100);
                }
                
        // Fill screen with gradient of colors
        for(int n = 0; n<=255; n++){
            array.fillScreen(0,n,0,255-n);
            array.write();
            wait_ms(5);
            }
        for(int n = 0; n<=255; n++){
            array.fillScreen(0,255-n,n,0);
            array.write();
            wait_ms(5);
            }
        for(int n = 0; n<=255; n++){
            array.fillScreen(0,0,255-n,n);
            array.write();
            wait_ms(5);
            }
            
        // Vertical scroll A B C
        for(char c = 'A'; c <= 'C'; c++)
            for(int i=8;i>=-8;i--){
                array.clear();
                array.drawChar(0,1,i,c, 255,255,255);
                array.write();
                wait_ms(100);
                }
            
        // Alternating Checkerboard
        for(int n=0; n<7; n++){
            for(int i=-8; i<8; i+=2){
                    array.drawLine(0, i+n%2,0,i+7+n%2,7,0,255,0);
                    }
                array.write();
                array.clear();
                wait_ms(500);
                }
            
        // Red and green pinwheel
        for(int i=0; i<8; i++){
            array.clear();
            array.drawLine(0,i,0,7-i,7,Red);
            array.drawLine(0,7,i,0,7-i,Green);
            array.write();
            wait_ms(100);
            }
        for(int i=1; i<=6; i++){
            array.clear();
            array.drawLine(0,7,i,0,7-i,Red);
            array.drawLine(0,i,0,7-i,7,Green);
            array.write();
            wait_ms(100);
            }
            
        // Shrink and grow blue rectangle
        for(int i=0; i<4; i++){
            array.clear();
            array.drawFilledRect(0,i,i,7-i,7-i,Blue);
            array.write();
            wait_ms(250);
            }
        for(int i=0; i<4; i++){
            array.clear();
            array.drawRect(0,3-i,3-i,4+i,4+i,Blue);
            array.write();
            wait_ms(250);
            }
            
        // Move purple triangle
        for(int i=7; i>=0; i--){
            array.clear();
            array.drawTriangle(0,i,i,0,7,7,0, 255,0,255);
            array.write();
            wait_ms(125);
            }
            
        // Rotate purple triangle
        for(int i=0; i<8; i++){
            array.clear();
            array.drawFilledTriangle(0,i,0,0,7-i,7,i, 255,0,255);
            array.write();
            wait_ms(250);
            }
     
        // Diangonal Rainbow Scroll
        for(int i=-1;i<=8;i++){
            for(int n=-18; n<=6; n+=6){
                array.drawLine(0,n+i,0,n+i+7,7, 255,0,0);
                array.drawLine(0,n+i+1,0,n+i+8,7, 255,255,0);
                array.drawLine(0,n+i+2,0,n+i+9,7, 0,255,0);
                array.drawLine(0,n+i+3,0,n+i+10,7, 0,255,255);
                array.drawLine(0,n+i+4,0,n+i+11,7, 0,0,255);
                array.drawLine(0,n+i+5,0,n+i+12,7, 255,0,255);
                }
            array.write();
            wait_ms(200);
           }
    }
}

