#include "mbed.h"
#include "TSISensor.h"


#define LED_OFF 1.0
// Using pulse width modulation, the closer this value is to 0.0, the
// brighter the LED will be.
#define LED_ON 0.9


// Use pulse width modulation to decrease the LED's brightness.
PwmOut greenLed(LED_GREEN);
PwmOut redLed(LED_RED);
PwmOut blueLed(LED_BLUE);

// The blue LED is controlled by the button.
// The green LED is controlled by the KL25Z's touch sensor.
// The red LED is controlled by the cpuIntensive() function.
InterruptIn button(PTA1);
TSISensor tsi;
Ticker flipper;

// The serial connection is available, if necessary, for debugging purposes.
Serial pc(USBTX,USBRX);


// Function prototype.
void cpuIntensive();


void flip()
{
    greenLed = LED_ON + (LED_OFF - LED_ON) * (1.0 - tsi.readPercentage());
}


void rise()
{
    blueLed = LED_OFF;
}


void fall()
{
    blueLed = LED_ON;
}


int main(void)
{
    button.mode(PullUp);
    flipper.attach(flip, 0.1);
    button.rise(rise);
    button.fall(fall);
    redLed = greenLed = blueLed = LED_OFF;

    while (1) {
        cpuIntensive();
    }
}


// Using the long wait()s, simulate a CPU-intensive process.
void cpuIntensive()
{
    redLed = LED_ON;
    wait(2.0);
    redLed = LED_OFF;
    wait(3.0);
}