/*
Copyright (c) 2011 Anthony Buckton (abuckton [at] blackink [dot} net {dot} au)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include <mbed.h>
#include <string>
#include <list>
#include "uLCD_4DGL.h"
#include <mpr121.h>
#include "SDFileSystem.h"
#include "SongPlayer.h"

//initialize lcd
uLCD_4DGL lcd(p9, p10, p30); // tx, rx, reset

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//setup analog in pin to read noise for random number generation
AnalogIn   Ain(p15);

//Setup class D audio output on pwm out pin
SongPlayer mySpeaker(p21);

//Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

//Setup the Serial to the PC for debugging
Serial pc(USBTX, USBRX);

//setup SD card filesystem
SDFileSystem sd(p5, p6, p7, p8, "sd");

// Setup the i2c bus on pins 28 and 27
I2C i2c(p28, p27);

//setup the note to be played upon hitting a mole
float note[1]= {1568.0};
float duration[1]= {0.1};

//initialize the possition integers
int pos1;
int pos2;
int pos3;
int pos4;
int pos5;
int pos6;

//initialize global variable to keep track of the score
int score = 0;

//create variables for the keypad outputs that correspond to mole possitions
int hole1 = 0x100;
int hole2 = 0x10;
int hole3 = 0x1;
int hole4 = 0x200;
int hole5 = 0x20;
int hole6 = 0x2;

//create a character buffer to read from the SD card
char str [80];

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

void fallInterrupt() {
    int key_code=0;
    int i=0;
    
    //read values from keypad after interupt and bitshift left 8 times
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    //Check to see if the a mole is hit after an interupt
    if (value==256&&pos1==1)
    {
        mySpeaker.PlaySong(note,duration);//play note to indicate successful hit
        score++;//increment score by one
        pos1 = 0;//set the position to 0 after succesful hit to prevent multiple hits
    }
        if (value==16&&pos2==1)
    {
        mySpeaker.PlaySong(note,duration);
        score++;
        pos2 = 0;
    }
        if (value==1&&pos3==1)
            {
        mySpeaker.PlaySong(note,duration);
        score++;
        pos3 = 0;
    }
        if (value==512&&pos4==1)
    {
        mySpeaker.PlaySong(note,duration);
        score++;
        pos4 = 0;
    }
        if (value==32&&pos5==1)
    {
        mySpeaker.PlaySong(note,duration);
        score++;
        pos5 = 0;
    }
        if (value==2&&pos6==1)
    {
        mySpeaker.PlaySong(note,duration);
        score++;
        pos6 = 0;
    }
}
float arand;// variable to store analog noise
unsigned int state; // global state variable

int main() {
lcd.baudrate(300000);// set lcd baudrate
    
int out = 0xFF0000;// outline color
int fill = 0x0000;// fill color. aka no mole
int col1 = 21;
int col2 = 64;
int col3=107;
int row3=107;
int row2=64;
int row1=21; 
int r = 20;
int rmole=18;//radius mole
int mole= 0xD3D3D3;//mole color like gray


//mole face
int lx114=10;//14x
int lx214=17;
int rx114=25;
int rx214=32;
int lx125=53;//25x
int lx225=60;
int rx125=68;
int rx225=75;
int lx136=97;//36x
int lx236=103;
int rx136=111;
int rx236=118;

int eyey123=10;//123y
int eyey456=56;//456y
int eyecolor=0x0000;
int nosecolor=0x0000;
int whisker=0x0000;
int rnose=2;

int wb123=27;//pos123
int wm123=21;
int wt123=15;
int wb456=70;//pos456
int wm456=64;
int wt456=58;




lcd.circle(col1, row1 , r, out);// draws 6 circles to the lcd screen to show where the moles will appear
lcd.circle(col1, row2 , r, out);
lcd.circle(col2, row1 , r, out);
lcd.circle(col2, row2 , r, out);
lcd.circle(col3, row1 , r, out);
lcd.circle(col3, row2 , r, out);

// Begin test code for mpr121
pc.printf("\nHello from the mbed & mpr121\n\r");

unsigned char dataArray[2];
int key;
int count = 0;

pc.printf("Test 1: read a value: \r\n");
dataArray[0] = mpr121.read(AFE_CFG);
    pc.printf("Read value=%x\r\n\n",dataArray[0]);

    pc.printf("Test 2: read a value: \r\n");
    dataArray[0] = mpr121.read(0x5d);
    pc.printf("Read value=%x\r\n\n",dataArray[0]);

    pc.printf("Test 3: write & read a value: \r\n");
    mpr121.read(ELE0_T);
    mpr121.write(ELE0_T,0x22);
    dataArray[0] = mpr121.read(ELE0_T);
    pc.printf("Read value=%x\r\n\n",dataArray[0]);

    pc.printf("Test 4: Write many values: \r\n");
    unsigned char data[] = {0x1,0x3,0x5,0x9,0x15,0x25,0x41};
    mpr121.writeMany(0x42,data,7);

    // Now read them back ..
    key = 0x42;
    count = 0;
    while (count < 7) {
        char result = mpr121.read(key);
        key++;
        count++;
        pc.printf("Read value: '%x'=%x\n\r",key,result);
    }

    pc.printf("Test 5: Read Electrodes:\r\n");
    key = ELE0_T;
    count = 0;
    while (count < 24) {
        char result = mpr121.read(key);
        pc.printf("Read key:%x value:%x\n\r",key,result);
        key++;
        count++;
    }
    pc.printf("--------- \r\n\n");

    // mpr121.setProximityMode(true);

    pc.printf("ELE_CFG=%x", mpr121.read(ELE_CFG));
// end test code of mpr121


    interrupt.fall(&fallInterrupt);//set up the interrupt mode
    interrupt.mode(PullUp);
    
    int counter = 0;// initialize the variable to count the number of transitions per game
    
    //read in a psuedo random noise reading and multiply so that it can later be cast to int by truncation
    arand = Ain.read()*1000000;
    
    //seed rand with noise reading
    srand(arand);
    
    //game runs for transitions
    while (counter < 30) {

        //determine state using rand()
        state = rand()%15;

        //switch the value of state to determine the output to the lcd
        switch(state)
        {
            case 0:
            //mutex functionality can be incorperated my uncommenting //POS_MUTEX.un/lock()
            //POS_MUTEX.lock();
            pos1=1;
            pos2=0;
            pos3=0;
            pos4=0;
            pos5=0;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 0 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 1
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col1, row1 , rmole, mole);
            //face1
            lcd.line(lx114, eyey123 , lx214, eyey123, eyecolor);//left eye
            lcd.line(rx114, eyey123 , rx214, eyey123, eyecolor);//right eye
            lcd.line(lx114, wb123 , rx214, wt123, whisker);//bottom
            lcd.line(lx114, wm123 , rx214, wm123, whisker);//middle
            lcd.line(lx114, wt123 , rx214, wb123, whisker);//top
            lcd.filled_circle(col1, row1 , rnose, nosecolor);//nose

            
            break;
            case 1:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=1;
            pos3=0;
            pos4=0;
            pos5=0;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 1 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 2
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, mole);
            //face2
            lcd.line(lx125, eyey123 , lx225, eyey123, eyecolor);//left eye
            lcd.line(rx125, eyey123 , rx225, eyey123, eyecolor);//right eye
            lcd.line(lx125, wb123 , rx225, wt123, whisker);//bottom
            lcd.line(lx125, wm123 , rx225, wm123, whisker);//middle
            lcd.line(lx125, wt123 , rx225, wb123, whisker);//top
            lcd.filled_circle(col2, row1 , rnose, nosecolor);//nose
            break;
            case 2:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=0;
            pos3=1;
            pos4=0;
            pos5=0;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 2 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 3
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, mole);
            
            //face3
            lcd.line(lx136, eyey123 , lx236, eyey123, eyecolor);//left eye
            lcd.line(rx136, eyey123 , rx236, eyey123, eyecolor);//right eye
            lcd.line(lx136, wb123 , rx236, wt123, whisker);//bottom
            lcd.line(lx136, wm123 , rx236, wm123, whisker);//middle
            lcd.line(lx136, wt123 , rx236, wb123, whisker);//top
            lcd.filled_circle(col3, row1 , rnose, nosecolor);//nose
            break;
            case 3:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=0;
            pos3=0;
            pos4=1;
            pos5=0;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 3 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 4
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col1, row2 , rmole, mole);
            
            //face4
            lcd.line(lx114, eyey456 , lx214, eyey456, eyecolor);//left eye
            lcd.line(rx114, eyey456 , rx214, eyey456, eyecolor);//right eye
            lcd.line(lx114, wb456 , rx214, wt456, whisker);//bottom
            lcd.line(lx114, wm456 , rx214, wm456, whisker);//middle
            lcd.line(lx114, wt456 , rx214, wb456, whisker);//top
            lcd.filled_circle(col1, row2 , rnose, nosecolor);//nose
            
            break;
            case 4:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=0;
            pos3=0;
            pos4=0;
            pos5=1;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 4 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 5
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, mole);
            //face5
             lcd.line(lx125, eyey456 , lx225, eyey456, eyecolor);//left eye
            lcd.line(rx125, eyey456 , rx225, eyey456, eyecolor);//right eye
            lcd.line(lx125, wb456 , rx225, wt456, whisker);//bottom
            lcd.line(lx125, wm456 , rx225, wm456, whisker);//middle
            lcd.line(lx125, wt456 , rx225, wb456, whisker);//top
            lcd.filled_circle(col2, row2 , rnose, nosecolor);//nose
            
            break;
            case 5:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=0;
            pos3=0;
            pos4=0;
            pos5=0;
            pos6=1;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 5 \n\r",state);
            
            lcd.filled_circle(col1, row1 , rmole, fill);// 6
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, mole);
            //face6
             lcd.line(lx136, eyey456 , lx236, eyey456, eyecolor);//left eye
            lcd.line(rx136, eyey456 , rx236, eyey456, eyecolor);//right eye
            lcd.line(lx136, wb456 , rx236, wt456, whisker);//bottom
            lcd.line(lx136, wm456 , rx236, wm456, whisker);//middle
            lcd.line(lx136, wt456 , rx236, wb456, whisker);//top
            lcd.filled_circle(col3, row2 , rnose, nosecolor);//nose
            
            break;
            case 6:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=1;
            pos3=0;
            pos4=0;
            pos5=0;
            pos6=1;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 6 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 2,6
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, mole);
            lcd.filled_circle(col3, row2 , rmole, mole);
            
            //face2
            lcd.line(lx125, eyey123 , lx225, eyey123, eyecolor);//left eye
            lcd.line(rx125, eyey123 , rx225, eyey123, eyecolor);//right eye
            lcd.line(lx125, wb123 , rx225, wt123, whisker);//bottom
            lcd.line(lx125, wm123 , rx225, wm123, whisker);//middle
            lcd.line(lx125, wt123 , rx225, wb123, whisker);//top
            lcd.filled_circle(col2, row1 , rnose, nosecolor);//nose
            //face6
            lcd.line(lx136, eyey456 , lx236, eyey456, eyecolor);//left eye
            lcd.line(rx136, eyey456 , rx236, eyey456, eyecolor);//right eye
            lcd.line(lx136, wb456 , rx236, wt456, whisker);//bottom
            lcd.line(lx136, wm456 , rx236, wm456, whisker);//middle
            lcd.line(lx136, wt456 , rx236, wb456, whisker);//top
            lcd.filled_circle(col3, row2 , rnose, nosecolor);//nose
            break;
            case 7:
            //POS_MUTEX.lock();
            pos1=1;
            pos2=0;
            pos3=1;
            pos4=0;
            pos5=0;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 7 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 1,3
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col1, row1 , rmole, mole);
            lcd.filled_circle(col3, row1 , rmole, mole);
            
            //face1
            lcd.line(lx114, eyey123 , lx214, eyey123, eyecolor);//left eye
            lcd.line(rx114, eyey123 , rx214, eyey123, eyecolor);//right eye
            lcd.line(lx114, wb123 , rx214, wt123, whisker);//bottom
            lcd.line(lx114, wm123 , rx214, wm123, whisker);//middle
            lcd.line(lx114, wt123 , rx214, wb123, whisker);//top
            lcd.filled_circle(col1, row1 , rnose, nosecolor);//nose
            //face3
            lcd.line(lx136, eyey123 , lx236, eyey123, eyecolor);//left eye
            lcd.line(rx136, eyey123 , rx236, eyey123, eyecolor);//right eye
            lcd.line(lx136, wb123 , rx236, wt123, whisker);//bottom
            lcd.line(lx136, wm123 , rx236, wm123, whisker);//middle
            lcd.line(lx136, wt123 , rx236, wb123, whisker);//top
            lcd.filled_circle(col3, row1 , rnose, nosecolor);//nose
            break;
            case 8:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=1;
            pos3=0;
            pos4=1;
            pos5=0;
            pos6=1;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 8 \n\r",state);
            
            lcd.filled_circle(col1, row1 , rmole, fill);// 2,4,6
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, mole);
            lcd.filled_circle(col1, row2 , rmole, mole);
            //face2
            lcd.line(lx125, eyey123 , lx225, eyey123, eyecolor);//left eye
            lcd.line(rx125, eyey123 , rx225, eyey123, eyecolor);//right eye
            lcd.line(lx125, wb123 , rx225, wt123, whisker);//bottom
            lcd.line(lx125, wm123 , rx225, wm123, whisker);//middle
            lcd.line(lx125, wt123 , rx225, wb123, whisker);//top
            lcd.filled_circle(col2, row1 , rnose, nosecolor);//nose
            //face4
            lcd.line(lx114, eyey456 , lx214, eyey456, eyecolor);//left eye
            lcd.line(rx114, eyey456 , rx214, eyey456, eyecolor);//right eye
            lcd.line(lx114, wb456 , rx214, wt456, whisker);//bottom
            lcd.line(lx114, wm456 , rx214, wm456, whisker);//middle
            lcd.line(lx114, wt456 , rx214, wb456, whisker);//top
            lcd.filled_circle(col1, row2 , rnose, nosecolor);//nose
            
            break;
            case 9:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=0;
            pos3=1;
            pos4=1;
            pos5=0;
            pos6=1;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 9 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 3,4,6
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, mole);
            lcd.filled_circle(col1, row2 , rmole, mole);
            lcd.filled_circle(col3, row2 , rmole, mole);
            //face3
            lcd.line(lx136, eyey123 , lx236, eyey123, eyecolor);//left eye
            lcd.line(rx136, eyey123 , rx236, eyey123, eyecolor);//right eye
            lcd.line(lx136, wb123 , rx236, wt123, whisker);//bottom
            lcd.line(lx136, wm123 , rx236, wm123, whisker);//middle
            lcd.line(lx136, wt123 , rx236, wb123, whisker);//top
            lcd.filled_circle(col3, row1 , rnose, nosecolor);//nose
            //face4
            lcd.line(lx114, eyey456 , lx214, eyey456, eyecolor);//left eye
            lcd.line(rx114, eyey456 , rx214, eyey456, eyecolor);//right eye
            lcd.line(lx114, wb456 , rx214, wt456, whisker);//bottom
            lcd.line(lx114, wm456 , rx214, wm456, whisker);//middle
            lcd.line(lx114, wt456 , rx214, wb456, whisker);//top
            lcd.filled_circle(col1, row2 , rnose, nosecolor);//nose
            //face6
            lcd.line(lx136, eyey456 , lx236, eyey456, eyecolor);//left eye
            lcd.line(rx136, eyey456 , rx236, eyey456, eyecolor);//right eye
            lcd.line(lx136, wb456 , rx236, wt456, whisker);//bottom
            lcd.line(lx136, wm456 , rx236, wm456, whisker);//middle
            lcd.line(lx136, wt456 , rx236, wb456, whisker);//top
            lcd.filled_circle(col3, row2 , rnose, nosecolor);//nose
            break;
            case 10:
            //POS_MUTEX.lock();
            pos1=1;
            pos2=0;
            pos3=0;
            pos4=0;
            pos5=0;
            pos6=1;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 10 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 1,6
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col1, row1 , rmole, mole);
            lcd.filled_circle(col3, row2 , rmole, mole);
            //face1
            lcd.line(lx114, eyey123 , lx214, eyey123, eyecolor);//left eye
            lcd.line(rx114, eyey123 , rx214, eyey123, eyecolor);//right eye
            lcd.line(lx114, wb123 , rx214, wt123, whisker);//bottom
            lcd.line(lx114, wm123 , rx214, wm123, whisker);//middle
            lcd.line(lx114, wt123 , rx214, wb123, whisker);//top
            lcd.filled_circle(col1, row1 , rnose, nosecolor);//nose
            //face6
            lcd.line(lx136, eyey456 , lx236, eyey456, eyecolor);//left eye
            lcd.line(rx136, eyey456 , rx236, eyey456, eyecolor);//right eye
            lcd.line(lx136, wb456 , rx236, wt456, whisker);//bottom
            lcd.line(lx136, wm456 , rx236, wm456, whisker);//middle
            lcd.line(lx136, wt456 , rx236, wb456, whisker);//top
            lcd.filled_circle(col3, row2 , rnose, nosecolor);//nose
            break;
            case 11:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=1;
            pos3=1;
            pos4=0;
            pos5=1;
            pos6=1;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 11 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 2,3,5,6
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, mole);
            lcd.filled_circle(col3, row1 , rmole, mole);
            lcd.filled_circle(col2, row2 , rmole, mole);
            lcd.filled_circle(col3, row2 , rmole, mole);
            //face2
            lcd.line(lx125, eyey123 , lx225, eyey123, eyecolor);//left eye
            lcd.line(rx125, eyey123 , rx225, eyey123, eyecolor);//right eye
            lcd.line(lx125, wb123 , rx225, wt123, whisker);//bottom
            lcd.line(lx125, wm123 , rx225, wm123, whisker);//middle
            lcd.line(lx125, wt123 , rx225, wb123, whisker);//top
            lcd.filled_circle(col2, row1 , rnose, nosecolor);//nose
            //face3
            lcd.line(lx136, eyey123 , lx236, eyey123, eyecolor);//left eye
            lcd.line(rx136, eyey123 , rx236, eyey123, eyecolor);//right eye
            lcd.line(lx136, wb123 , rx236, wt123, whisker);//bottom
            lcd.line(lx136, wm123 , rx236, wm123, whisker);//middle
            lcd.line(lx136, wt123 , rx236, wb123, whisker);//top
            lcd.filled_circle(col3, row1 , rnose, nosecolor);//nose
            //face5
            lcd.line(lx125, eyey456 , lx225, eyey456, eyecolor);//left eye
            lcd.line(rx125, eyey456 , rx225, eyey456, eyecolor);//right eye
            lcd.line(lx125, wb456 , rx225, wt456, whisker);//bottom
            lcd.line(lx125, wm456 , rx225, wm456, whisker);//middle
            lcd.line(lx125, wt456 , rx225, wb456, whisker);//top
            lcd.filled_circle(col2, row2 , rnose, nosecolor);//nose
            //face6
             lcd.line(lx136, eyey456 , lx236, eyey456, eyecolor);//left eye
            lcd.line(rx136, eyey456 , rx236, eyey456, eyecolor);//right eye
            lcd.line(lx136, wb456 , rx236, wt456, whisker);//bottom
            lcd.line(lx136, wm456 , rx236, wm456, whisker);//middle
            lcd.line(lx136, wt456 , rx236, wb456, whisker);//top
            lcd.filled_circle(col3, row2 , rnose, nosecolor);//nose
            
            break;
            case 12:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=0;
            pos3=1;
            pos4=0;
            pos5=1;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 12 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 3,5
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, mole);
            lcd.filled_circle(col2, row2 , rmole, mole);
            
            //face3
            lcd.line(lx136, eyey123 , lx236, eyey123, eyecolor);//left eye
            lcd.line(rx136, eyey123 , rx236, eyey123, eyecolor);//right eye
            lcd.line(lx136, wb123 , rx236, wt123, whisker);//bottom
            lcd.line(lx136, wm123 , rx236, wm123, whisker);//middle
            lcd.line(lx136, wt123 , rx236, wb123, whisker);//top
            lcd.filled_circle(col3, row1 , rnose, nosecolor);//nose
            //face5
            lcd.line(lx125, eyey456 , lx225, eyey456, eyecolor);//left eye
            lcd.line(rx125, eyey456 , rx225, eyey456, eyecolor);//right eye
            lcd.line(lx125, wb456 , rx225, wt456, whisker);//bottom
            lcd.line(lx125, wm456 , rx225, wm456, whisker);//middle
            lcd.line(lx125, wt456 , rx225, wb456, whisker);//top
            lcd.filled_circle(col2, row2 , rnose, nosecolor);//nose
            break;
            case 13:
            //POS_MUTEX.lock();
            pos1=1;
            pos2=0;
            pos3=0;
            pos4=1;
            pos5=1;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 13 \n\r",state);
            lcd.filled_circle(col1, row1 , rmole, fill);// 1,4,5
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col1, row1 , rmole, mole);
            lcd.filled_circle(col1, row2 , rmole, mole);
            lcd.filled_circle(col2, row2 , rmole, mole);
            //face1
            lcd.line(lx114, eyey123 , lx214, eyey123, eyecolor);//left eye
            lcd.line(rx114, eyey123 , rx214, eyey123, eyecolor);//right eye
            lcd.line(lx114, wb123 , rx214, wt123, whisker);//bottom
            lcd.line(lx114, wm123 , rx214, wm123, whisker);//middle
            lcd.line(lx114, wt123 , rx214, wb123, whisker);//top
            lcd.filled_circle(col1, row1 , rnose, nosecolor);//nose

            //face4
             lcd.line(lx114, eyey456 , lx214, eyey456, eyecolor);//left eye
            lcd.line(rx114, eyey456 , rx214, eyey456, eyecolor);//right eye
            lcd.line(lx114, wb456 , rx214, wt456, whisker);//bottom
            lcd.line(lx114, wm456 , rx214, wm456, whisker);//middle
            lcd.line(lx114, wt456 , rx214, wb456, whisker);//top
            lcd.filled_circle(col1, row2 , rnose, nosecolor);//nose
            //face5
            lcd.line(lx125, eyey456 , lx225, eyey456, eyecolor);//left eye
            lcd.line(rx125, eyey456 , rx225, eyey456, eyecolor);//right eye
            lcd.line(lx125, wb456 , rx225, wt456, whisker);//bottom
            lcd.line(lx125, wm456 , rx225, wm456, whisker);//middle
            lcd.line(lx125, wt456 , rx225, wb456, whisker);//top
            lcd.filled_circle(col2, row2 , rnose, nosecolor);//nose
            break;
            case 14:
            //POS_MUTEX.lock();
            pos1=0;
            pos2=1;
            pos3=0;
            pos4=0;
            pos5=1;
            pos6=0;
            //POS_MUTEX.unlock();
            pc.printf("%i should be 14 \n\r",state);
            
            lcd.filled_circle(col1, row1 , rmole, fill);// 2,5
            lcd.filled_circle(col1, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, fill);
            lcd.filled_circle(col2, row2 , rmole, fill);
            lcd.filled_circle(col3, row1 , rmole, fill);
            lcd.filled_circle(col3, row2 , rmole, fill);
            lcd.filled_circle(col2, row1 , rmole, mole);
            lcd.filled_circle(col2, row2 , rmole, mole);
            
            //face2
            lcd.line(lx125, eyey123 , lx225, eyey123, eyecolor);//left eye
            lcd.line(rx125, eyey123 , rx225, eyey123, eyecolor);//right eye
            lcd.line(lx125, wb123 , rx225, wt123, whisker);//bottom
            lcd.line(lx125, wm123 , rx225, wm123, whisker);//middle
            lcd.line(lx125, wt123 , rx225, wb123, whisker);//top
            lcd.filled_circle(col2, row1 , rnose, nosecolor);//nose
            //face5
            lcd.line(lx125, eyey456 , lx225, eyey456, eyecolor);//left eye
            lcd.line(rx125, eyey456 , rx225, eyey456, eyecolor);//right eye
            lcd.line(lx125, wb456 , rx225, wt456, whisker);//bottom
            lcd.line(lx125, wm456 , rx225, wm456, whisker);//middle
            lcd.line(lx125, wt456 , rx225, wb456, whisker);//top
            lcd.filled_circle(col2, row2 , rnose, nosecolor);//nose
            break;
            }
        wait(0.5);
        counter++; // increment counter and run the "state machine again"
        lcd.text_string("Score: ", 1, 15, FONT_7X8, GREEN);
        lcd.printf("%d",score);
        }
        
    // clear the lcd screen
    lcd.cls();
    wait(0.5);
    lcd.cls();
    // int variable to read current high score
    int please;
    mkdir("/sd/mydir", 0777);
    FILE *fp1 = fopen("/sd/mydir/sdtest.txt", "r"); 
    if(fp1 == NULL) 
    { 
    pc.printf("Could not open file for read\n"); 
    }
    pc.printf("Opened file for read\n\r");
    fscanf (fp1, "%s", str);
    sscanf(str, "%d", &please);
    fclose(fp1);
    pc.printf (":   %d \n",please);
    if (score > please)
    {
        FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
        if(fp == NULL) {
        error("Could not open file for write\n");
    }
    char buf[10];
    sprintf(buf, "%d", score);
    fprintf(fp, "%s",buf);
    fclose(fp); 
        lcd.printf("CONGRATULATIONS!\n\n");
        lcd.printf("You set the new\n\n");
        lcd.printf("High score!!!!!!\n\n");
        lcd.printf("New high score: %d\n\n",score);
        lcd.printf("Press reset to\n\n");
        lcd.printf("Play Again!");
    }
    else
    {
        lcd.printf("High score: %d\n\n",please);
        lcd.printf("Your score: %d\n\n",score);
        lcd.printf("You did not set\n\n");
        lcd.printf("A new high score\n\n");
        lcd.printf("Press reset to\n\n");
        lcd.printf("Try again");
    }

pc.printf("Goodbye World!\n");
}//end




