#include <stdint.h>
#include "mbed.h"

uint8_t curkey = 0;

Serial ser(SERIAL_TX, SERIAL_RX);


extern "C" {
    uint16_t getpc();
    uint8_t getop();
    void exec6502(int32_t tickcount);
    void reset6502();
    void serout(uint8_t val)
    {
        ser.printf("%c", val);
    }
    uint8_t getkey()
    {
        return(curkey);
    }
    void clearkey()
    {
        curkey = 0;
    }
    void printhex(uint16_t val)
    {
        ser.printf("%#08x", val);
    }
}

int main ()
{
    ser.baud (115200);
    ser.printf("\nStart\n");

    reset6502();

    while(1) {
        exec6502(100); //if timing is enabled, this value is in 6502 clock ticks. otherwise, simply instruction count.
        if(ser.readable()) {
            curkey = ser.getc() & 0x7F;
        }
    }
}