
#ifndef _NMEA_PARSE_H
#define _NMEA_PARSE_H
#ifdef __cplusplus
extern "C" {
#endif

#define    LIBNMEA_PARSE_NONE        (0)
#define    LIBNMEA_PARSE_SUMOK        (10)
#define    LIBNMEA_PARSE_COMPLETE    (100)

#define    LIBNMEA_NUMSOFARRAY(array)    (sizeof((array))/sizeof((array)[0]))

typedef double libNMEA_realnum_t;
typedef long   libNMEA_intnum_t;

typedef struct {
//    unsigned char isValid;
    unsigned char active;         /* '0' or '1' = Fix not available,'2' = 2D,'3' = 3D */
    unsigned char positioning;    /* 'A' = 単独測位，D = DGPS，N = 無効 */
} libNMEA_gps_status_t;

typedef struct {
    unsigned long res1:1;
    unsigned long year:12;
    unsigned long mon:4;
    unsigned long day:6;
    unsigned long res2:9;
} libNMEA_gps_date_t;

typedef struct {
    unsigned long res:1;
    unsigned long hour:5;
    unsigned long min:6;
    unsigned long sec:6;
    unsigned long msec:14;
} libNMEA_gps_time_t;

typedef struct {
//    unsigned char isValid;
    unsigned char unit;
    libNMEA_realnum_t deg;
} libNMEA_gps_deg_t;

typedef struct {
    unsigned char lat_unit;    /* 'N'(Nouth) or 'S'(South) */
    unsigned char lon_unit;    /* 'W'(West) or 'E'(East) */
    libNMEA_realnum_t latitude;
    libNMEA_realnum_t longitude;
} libNMEA_gps_latlon_t;

typedef struct {
//    unsigned char isValid;
    libNMEA_realnum_t ground;
} libNMEA_gps_speed_t;

typedef struct {
//    unsigned char isValid;
    libNMEA_realnum_t dop;
} libNMEA_gps_dop_t;

typedef struct {
    libNMEA_gps_deg_t trueNorth;
    libNMEA_gps_deg_t magnetic;
    libNMEA_gps_deg_t mag_dec;
} libNMEA_gps_direction_t;

typedef struct {
    libNMEA_gps_dop_t    h;
    libNMEA_gps_dop_t    v;
    libNMEA_gps_dop_t    p;
} libNMEA_gps_accuracy_t;

typedef struct {
    unsigned long status:1;    /* これが１ならば，GPS のデータを信用する */
    unsigned long active:1;
    unsigned long positioning:1;
    unsigned long date:1;
    unsigned long timeRMC:1;
    unsigned long timeZDA:1;
    unsigned long latitude:1;
    unsigned long longitude:1;
    unsigned long speed:1;
    unsigned long direction:1;
    unsigned long accuracy_hdop:1;
    unsigned long accuracy_vdop:1;
    unsigned long accuracy_pdop:1;
    unsigned long res:19;
} libNMEA_gps_valid_t;

typedef struct {
    libNMEA_gps_valid_t     valid;
    libNMEA_gps_status_t    status;
    libNMEA_gps_date_t      date;
    libNMEA_gps_time_t      time;
    libNMEA_gps_latlon_t    latlon;
    libNMEA_gps_speed_t     speed;
    libNMEA_gps_direction_t direction;
    libNMEA_gps_accuracy_t  accuracy;
} libNMEA_gps_info_t;

typedef struct {
    short cjobst;
    unsigned char raw[82+2];
    short rawLength;
    unsigned char sum;
    unsigned char sumwk;
    short argc;
    short argv[31];     /* NMEA センテンスで処理できる最大トークン数．メモリを節約したいのでポインタではなく先頭からのオフセットにしている． */
} libNMEA_data_t;

extern short libNMEA_Parse1Char(unsigned char c,libNMEA_data_t *buffer);
short libNMEA_Parse1Line(libNMEA_data_t *buffer,libNMEA_gps_info_t *GPSinfo);

#ifdef __cplusplus
}
#endif

#endif /* _NMEA_PARSE_H */
