
#ifndef __TSERIALBUFFER_H
#define __TSERIALBUFFER_H

#include "mbed.h"
#include "libT/portable/tringbuffer.h"
#include "libT/portable/tversion.h"

namespace libT {

class tSerialBuffer : public tRingBuffer<unsigned char> , public Serial , public tVersion {

public:
    tSerialBuffer(PinName _tx, PinName _rx) : Serial(_tx,_rx) , tVersion(0x20100720/* 2010-07-20 */,0x00000001UL){}

    void recvStart(void){
        Serial::attach(this,&tSerialBuffer::recvHandler,Serial::RxIrq);
    }
    void recvStop(void){
        Serial::attach(0,Serial::RxIrq);
    }

    int readable(void){
        return tRingBuffer::readable();
    }

    int getc(void){
        unsigned char _c;
        int retval = -1;
        if(tRingBuffer::readable()){
            (void)tRingBuffer::read(&_c);
            retval = static_cast<int>(_c);
        }
        return retval;
    }

private:
    void recvHandler(void){
        if(Serial::readable()){
            tRingBuffer::write(static_cast<unsigned char>(Serial::getc()));
        }
    }

};

};

#endif /* __TSERIALBUFFER_H */

