/**
 * @section LICENSE
 *
 * This source code is "zlib" license. 
 * Of course, this is not a part of the zlib software. 
 * The license is zlib license. 
 *
 * Copyright (C) 2010 tosihisa <tosihisa _at_ netfort.gr.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * @section DESCRIPTION
 *
 */
#include "mbed.h"
#include "RDCM802.h"

RDCM802::RDCM802( PinName d0, PinName d1 ,PinName d2 ) : _d0(d0) , _d1(d1) , _d2(d2)
{
}

int RDCM802::read()
{
    int retval = 0;
    retval  = (_d2 != 0) ? 0x04 : 0;
    retval |= (_d1 != 0) ? 0x02 : 0;
    retval |= (_d0 != 0) ? 0x01 : 0;
    return retval;
}

char *RDCM802::toString()
{
    char *retval[8] = { "S ","SW","NE","N ","SE","W ","E ","NW" };
    return retval[read()];
}

