
#include "mbed.h"
#include "LSM303DLH.h"

Serial debug(USBTX,USBRX);
LSM303DLH compass(p28, p27);

int main() {
  float hdg;
  float hdgV;
  vector acc;
  vector mag;
  debug.format(8,Serial::None,1);
  debug.baud(115200);
  debug.printf("LSM303DLH Test\x0d\x0a");
  compass.setOffset(0.00,0.00,0.00); // example calibration
  compass.setScale(1.00,1.00,1.00);    // example calibration
  while(1) {
    compass.read(acc,mag);
    hdg = compass.heading();
    hdgV = atan2(acc.y,acc.z) * 180/M_PI;
    debug.printf("ACC: %6.2f %6.2f %6.2f Heading: %6.2f %6.2f\n",acc.x,acc.y,acc.z,hdgV,hdg);
    wait(0.1);
  }
}
 