/*
 * Copyright (c) 2011 Toshihisa T
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "INA226.hpp"

Serial debug(USBTX,USBRX);
DigitalOut myled(LED1);
I2C i2c(p28,p27);
INA226 VCmonitor(i2c);

int main() {
    unsigned short val;
    double V,C;
    int count = 1;

    debug.format(8,ParityNone,1);
    debug.baud(115200);
    debug.printf("VCmonitor INA226 TEST Program. (BUILD:[" __DATE__ "/" __TIME__ "])\n");

    if(!VCmonitor.isExist()){
        debug.printf("VCmonitor NOT FOUND\n");
        while(1){}
    }
    debug.printf("VCmonitor FOUND\n");

    val = 0;
    if(VCmonitor.rawRead(0x00,&val) != 0){
        debug.printf("VCmonitor READ ERROR\n");
        while(1){}
    }
    debug.printf("VCmonitor Reg 0x00 : 0x%04x\n",val);

    VCmonitor.setCurrentCalibration();

    while(1) {
        if((VCmonitor.getVoltage(&V) == 0) && (VCmonitor.getCurrent(&C) == 0)){
            debug.printf("%d,V,%f,C,%f\n",count,V,C);
        }
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
        count++;
    }
}
