/*
 * Copyright (c) 2011 Toshihisa T
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef __TRINGBUFFER_H
#define __TRINGBUFFER_H

#include "tversion.h"

namespace libT {

template <class T>
class tRingBuffer : public tVersion
{
public:

    tRingBuffer(void) : tVersion(0x20100721/* 2010-07-21 */,0x00000001UL),wp(0),rp(0) {}

    inline void reset(void){wp = rp = 0;}

    inline int writable(void) const
    {
        return (inc(wp) != rp) ? 1 : 0;
    }

    inline int write(T _c)
    {
        int retval = -1;    /* Ringbuffer FULL */
        if(writable()){
            array[wp] = _c;
            wp = inc(wp);
            retval = 0;    /* OK */
        }
        return retval;
    }

    inline int readable(void) const
    {
        return (rp != wp) ? 1 : 0;
    }

    inline int read(T *_c)
    {
        int retval = -1;    /* Ringbuffer empty or _c is invalid*/
        if((readable()) && (_c != 0)){
            *_c = array[rp];
            rp = inc(rp);
            retval = 0;    /* OK */
        }
        return retval;
    }

private:
    enum {TRINGBUFFER_SIZE=0x2000};
    inline unsigned short inc(unsigned short _p) const
    {
        return static_cast<unsigned short>(static_cast<unsigned short>(_p + 1) & (sizeof(array)-1));
    }
    volatile unsigned short wp;
    volatile unsigned short rp;
    volatile T array[TRINGBUFFER_SIZE];
};

};

#endif /* __TRINGBUFFER_H */

