/*
 * Copyright (c) 2011 Toshihisa T
 * Released under the MIT License: http://mbed.org/license/mit
 */

extern "C" {
static int libT_getAccTOmV(unsigned long Val,long *mV);
int libT_getAcc1dot5G(unsigned long ADval,long *g);
int libT_getAcc6G(unsigned long ADval,long *g);
}


static int libT_getAccTOmV(unsigned long Val,long *mV)
{
    *mV = 0;

    /* AnalogIn = 1mV = 19.85939393939394 */
    if(Val >= 32767UL){
        *mV = ((Val - 32767UL) * 100UL) / 1985UL;
        *mV = 0 - *mV;
    } else {
        *mV = ((32767UL - Val) * 100UL) / 1985UL;
    }
    return 0;
}

int libT_getAcc1dot5G(unsigned long ADval,long *g)
{
    long mV = 0;
    libT_getAccTOmV(ADval,&mV);    /* A/D value to mV */
    *g = (long)(mV / 8);    /* 0.01g units */
    return 0;
}

int libT_getAcc6G(unsigned long ADval,long *g)
{
    long mV = 0;
    libT_getAccTOmV(ADval,&mV);    /* A/D value to mV */
    *g = (long)(mV / 2);    /* 0.01g units */
    return 0;
}

#if 0
int main(void)
{
    long g;

    libT_getAcc1dot5G(22767UL,&g);
    if(g >= 0){
        printf("1.5g g(DOWN)=%ld.%02ld\n",g/100,g%100);
    } else {
        g = g * -1;
        printf("1.5g g(UP)=%ld.%02ld\n",g/100,g%100);
    }
    libT_getAcc6G(22767UL,&g);
    if(g >= 0){
        printf("6g g(DOWN)=%ld.%02ld\n",g/100,g%100);
    } else {
        g = g * -1;
        printf("6g g(UP)=%ld.%02ld\n",g/100,g%100);
    }
    return 0;
}
#endif
