/*
 * Copyright (c) 2011 Toshihisa T
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "AD7994.h"

#define AD7994ADDR   (0x44)

AD7994::AD7994(PinName p_sda, PinName p_scl) : i2c(p_sda, p_scl)
{
    memset(ch_val,0,sizeof(ch_val));
}

void AD7994::Start()
{
    char cmd_set[] = { 0x02,0x38 };
    char cmd_tim[] = { 0x03,0x01 };
    i2c.write(AD7994ADDR,cmd_set,sizeof(cmd_set));
    i2c.write(AD7994ADDR,cmd_tim,sizeof(cmd_tim));
}

unsigned short AD7994::getVal()
{
    char cmd[] = { 0x00 };
    char buf[2];
    unsigned short res = 0;
    i2c.write(AD7994ADDR,cmd,sizeof(cmd));
    i2c.read(AD7994ADDR,buf,sizeof(buf));
    res = buf[0];
    res = (res << 8) | buf[1];
    return res;
}

void AD7994::update()
{
    int i;
    unsigned short res;
    unsigned short idx;
    for(i=0;i<4;i++){
        res = getVal();
        idx = (res >> 12) & 0x03;
        ch_val[idx] = res & 0x0FFF;
    }
}

unsigned short AD7994::readChn(int chnNo)
{
    return ch_val[chnNo];
}
