#ifndef CNT_MAN_H
#define CNT_MAN_H

#include "mbed.h"


class cnt_man {
public:

    cnt_man(PinName pin_in, PinName pin_out); 
    
    ~cnt_man();
 
    int read_in_count();
    int read_out_count();

    void reset_count();
    void reset_in_count();
    void reset_out_count();


private:    
    void clr_sta();
    void in_sensor_sLOW();
    void in_sensor_sHIGH();
    void out_sensor_sLOW();
    void out_sensor_sHIGH();
    void chk_visit();
    //void clr_state();
    
    volatile unsigned int _count_in;
    volatile unsigned int _count_out;
    volatile unsigned int _state;
    volatile bool _passed;
    
    volatile unsigned long lastT;
    
    bool _pin_in_state;
    bool _pin_out_state;
    
    InterruptIn _pin_in;
    InterruptIn _pin_out;
    
    Timer _t;
    
};

#endif