#include "CNT_MAN.h"

/** 
* Initialize the xband motion detector and setup interrupts. Default is to be disabled.
*
* @param pin_enable Enable pin. Connected to EN on xband.
* @param pin_input Data pin. Connected to OUT on xband.
*/ 
cnt_man::cnt_man(PinName pin_in, PinName pin_out)
    : _pin_in(pin_in), _pin_out(pin_out) {

    // Initialize count to be 0.
    _count_in = 0;
    _count_out = 0;
    _state = 0;
    _passed = true;
    
    _pin_in_state = true;
    _pin_out_state = true;
    
    // Setup interrupt on input pin.
    _pin_in.fall( this, &cnt_man::in_sensor_sLOW );
    _pin_in.rise( this, &cnt_man::in_sensor_sHIGH );
    
    _pin_out.fall( this, &cnt_man::out_sensor_sLOW );
    _pin_out.rise( this, &cnt_man::out_sensor_sHIGH );
    
    _pin_out.mode(PullDown);
    _pin_in.mode(PullDown);
    
    _t.start();
}

/**
* Destructor
*/
cnt_man::~cnt_man() {}


void cnt_man::clr_sta() {
    if ( _t.read_ms() - lastT > 1650 ) {
        _state = 0;
        //printf( "clear\n" );
    }
}

void cnt_man::in_sensor_sLOW(){
   _pin_in_state = false;
   chk_visit();
}

void cnt_man::in_sensor_sHIGH(){
   _pin_in_state = true;
   chk_visit();
}

void cnt_man::out_sensor_sLOW(){
   _pin_out_state = false;
   chk_visit();
}

void cnt_man::out_sensor_sHIGH(){
   _pin_out_state = true;
   chk_visit();
}


void cnt_man::chk_visit(){
    if ( _passed ) {
        clr_sta();
        
        if ( _state == 0 ) {
            if ( !_pin_in_state && _pin_out_state ) {      
                _state = 1;
                lastT = _t.read_ms();
            } else if ( _pin_in_state && !_pin_out_state ) {
                _state = 2;
                lastT = _t.read_ms();
            } 
      
        } else if ( _state == 1 ) {
            if ( _pin_in_state && !_pin_out_state ) {
                _state = 0;
                _count_out ++;
                printf( "#Out: %u\n", _count_out );
                _passed = false;
                      
                //_clrst.attach(this, &cnt_man::clr_state, 2);
            }
      
        } else if ( _state == 2 ) {
            if ( !_pin_in_state && _pin_out_state ) {
                _state = 0;
                _count_in ++;
                printf( "#In: %u\n", _count_in );
                
                lastT = _t.read_ms();
                //_clrst.attach(this, &cnt_man::clr_state, 2);
            }
        }
        
    } else {
        //printf( "#%u:%u\n" ,_pin_in_state ,_pin_out_state);
        if ( _pin_in_state && _pin_out_state ) {
            _passed = true;
            //_clrst.detach();
        } 
        
    }
}



int cnt_man::read_in_count()  {
    return _count_in;
}

int cnt_man::read_out_count() {
    return _count_out;
}

void cnt_man::reset_count(){
    _count_in = 0;
    _count_out = 0;
}

void cnt_man::reset_in_count(){
    _count_in = 0;
}

void cnt_man::reset_out_count(){
    _count_out = 0;
}

/*
xband::operator float() {
    return read_velocity();
}*/