/*
    class to write to a matrix led display.
    
    Written by tonymudd (mbed@tonymudd.co.uk)
    
*/
#include "mbed.h"

#ifndef MBED_MATRIXDISPLAY_H
#define MBED_MATRIXDISPLAY_H

class matrixDisplay
{
    public:
    matrixDisplay(  float scrollRate,   PinName clockPinIn, PinName dataPinIn,
                    PinName col1,       PinName col2,       PinName col3,
                    PinName col4,       PinName col5);
    virtual ~matrixDisplay();
    void setMessage(char * newMessage);
    void stop();

    private:
    void colChange();
    void outputCol(int);
    void loadDisplay();
    void scrollMessage();
    static const int numOfColumns = 5;
    static const int numOfRows = 7;
    static const int numOfChars = 4;
    static const int numOfLeds = numOfRows * numOfChars;
    int column;
    // fires when the column changes - fast
    Ticker colTick;
    // fires to scroll the chars along one - slow.
    Ticker scroll;
    bool display[numOfColumns][numOfLeds];  // on the display now
    char text[numOfChars];                  // text on the display
    char *message;                          // the whole message
    int whereInMessage;                     // which character in message to display next
    
    // And the hardware it uses:  
    DigitalOut  * clockPin;
    DigitalOut  * dataPin;      //    DigitalOut data(p20);
    BusOut      * columnsBus;   //  BusOut columns(p10,p11,p12,p13,p14);
    
};

#endif