#include "mbed.h"
#include "matrixDisplay.h"
#include "matrix.h"
#include <string>

matrixDisplay::matrixDisplay(   float scrollRate,   PinName clockPinIn,
                                PinName dataPinIn,  PinName col1,
                                PinName col2,       PinName col3,
                                PinName col4,       PinName col5)
{
    clockPin = new DigitalOut(clockPinIn);
    dataPin = new DigitalOut(dataPinIn);
    columnsBus = new BusOut(col1, col2, col3, col4, col5);
    column = 0;
    whereInMessage = 0;
    message = NULL;
    // clear the text array.
    for (int i =0 ; i < numOfChars; i++)
        text[i] = ' ';
    loadDisplay();
    colTick.attach_us(this, &matrixDisplay::colChange, 5000);
    scroll.attach(this, &matrixDisplay::scrollMessage, scrollRate);
}

matrixDisplay::~matrixDisplay()
{
    stop();
}

// Stop displaying stuff.
void matrixDisplay::stop()
{
    colTick.detach();
    scroll.detach();
    columnsBus->write( 0);
}

// load a new message
// keeps a pointer to it, so bad things could happen.
void matrixDisplay::setMessage(char * newMessage)
{
    for (int i =0 ; i < numOfChars; i++)
        text[i] = ' ';
    message = newMessage;
    whereInMessage = 0;
}

void matrixDisplay::outputCol(int colNum)  // colNum is 0-4
{
    for (int i = 0; i< numOfLeds; i++)  // once for each bool in the "display" which has already been set up
    {
        clockPin->write(1);
        if (display[colNum][i])
            dataPin->write(1);
        else
            dataPin->write(0);
        clockPin->write(0);
    }
}

void matrixDisplay::colChange()
{
    columnsBus->write( 0);
    column ++;
    if (column > 4)
        column = 0;
    outputCol(column);
    columnsBus->write (1 << column); // columns is a bit pattern
}

// turns the contents of "text" into the bit pattern in "display"
void matrixDisplay::loadDisplay()
{
    for (int i =0;i < numOfChars; i ++)   // for each char in text
    {
        char c = text[i];
        c -= 32;    // index an array starting at 0 for char ' ' (space)
        for (int led = 0; led < numOfRows; led++)   // for each led in the column, done this way round because that's the way it's stored in matrix.h
        {
            int bits = char_data[c][led];
            for (int col = 0; col < numOfColumns; col++)   // for each column
            {
                display[col][led+i*numOfRows] = (bits & 1<< col);
            }    
        }        
    }
}

void matrixDisplay::scrollMessage()
{
    if (message == NULL)    // It may not have been set yet.
        return;
    if (whereInMessage >= strlen(message))
        whereInMessage =0;
    for (int i=1;i<numOfChars;i++)
    {
        text[i-1] = text[i];
    }
    text[numOfChars-1] = message[whereInMessage];
    loadDisplay();
    whereInMessage ++;
}
