/*
* OneWireCRC/OneWireThermometer demo.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* This file is part of OneWireCRC/OneWireThermometer.
*
* OneWireCRC/OneWireThermometer is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* OneWireCRC/OneWireThermometer is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with OneWireCRC/OneWireThermometer0.  If not, see <http://www.gnu.org/licenses/>.
*/

////////////////////////////////////////////////////////////////////
// Test code to read temperature from a Maxim DS18B20 or DS18S20
// 1-wire device 
////////////////////////////////////////////////////////////////////

#include <mbed.h>
#include "DS18B20.h"
#include "OneWireDefs.h"

#define THERMOMETER DS18B20

float temp;
// device( mbed pin )
THERMOMETER device(p21);

void readTemp(int deviceNum)
{
    temp = device.readTemperature(deviceNum);
    printf("Device %d is %f\n\r",deviceNum, temp);
    wait(0.5);
}

int main()
{
    
    while (!device.initialize());    // keep calling until it works
    // Say how many were found.
    int deviceCount = device.getDeviceCount();
    printf("Found %d sensors\n\r",deviceCount);

    device.setResolution(twelveBit);
    while (true)
    {
        for (int i = 0;i < deviceCount; i++)
            readTemp(i);
    }
     
    //return EXIT_SUCCESS;  // Commented out to prevent the warning that this code is unreachable, due to the while(forever) above.
}

