#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"
#include <string>
#include <cstdio>

using std::string;

C12832 lcd(p5, p7, p6, p8, p11);

LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);
LocalFileSystem local("local");               // Create the local filesystem under the name "local"

int count;
float temperature;

void writeValue (float temperature){
    FILE *fp = fopen("/local/out.txt", "a");  // Open "out.txt" on the local file system for writing
    fprintf(fp,"%f\r\n",temperature);
    if (fp)
    {
        putc('\n',fp);
        //for(int i=0; i<; i++)
        //putc(string[i],fp);
        }
    //fputs("f\r\n",fp);
    fclose(fp);
    printf("New Entry Added\r\n");
    return;
}
void readFile (){
       FILE *fp = fopen("/local/out.txt", "r");
       if (fp == NULL){
            printf("File not found\r\n");
       }
       printf("Reading File\r\n");
      
       fclose(fp);
       
       return;
       
    
}
void displayValues (float temperature){
    
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Temp = %.3f\r\n", temperature);
    lcd.printf("Average = %.3f\r\n", 100.000);
    return;
}
    
    
int main ()
{
    count = 0; 
    //Try to open the LM75B
    while (1) {
        writeValue((float)sensor);
        displayValues((float)sensor);  
        readFile();
        printf("About to Wait 10 seconds\r\n");
        wait(10.0);
        count++;
    }
    //printf("We are done!");
}
