#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

InterruptIn joystickcenter(p14);
InterruptIn button(p9);
Timer debounce;

DigitalOut led(LED1);
DigitalOut flash(LED4);

int x ;

void flip() {
    led = !led; //toggles the led when the joystick is pressed.
    if (debounce.read_ms() > 3000 )
    
    x = 1; 
    debounce.reset();
    }
int main() {
    debounce.start();
    joystickcenter.rise(&flip); // attach the function address to the rising edge
    button.mode(PullUp);        // With this, no external pullup resistor needed
    button.rise(&flip);         // attach the function address to the rising edge
    
    while(1) 
    {                 // wait around, interrupts will interrupt this!
        flash = !flash;        // turns LED4 on if off, off if on
        if (x == 1)
        {
            wait (0.20);
            lcd.printf("high");
            x = 0;
        }
        wait(0.25);            // the instruction to wait for a quarter-second  
    }
}
