#ifndef GLCD_H
#define GLCD_H

#include "mbed.h"
#include "bitmap.h"
#include "font.h"


    
class gLCD : public Stream {
public:

   
    /* rst = Reset rs = Register Select   e = Enable   d0 - d7 = 8bit data bus */
   
    gLCD(PinName rst, PinName rs, PinName e, PinName d0, PinName d1, PinName d2, PinName d3, PinName d4, PinName d5, PinName d6, PinName d7, PinName led);


#if DOXYGEN_ONLY
       int putc(int c);
       int printf(const char* format, ...);
#endif
    
   
    
    /*  locate(page address, column address)
        Function to locate a position on the display */   
        void locate(int page, int column);
        
    /*  clearScreen()
        Function to clear entire display */
        void clearScreen();
    
    /*  writeBitmap(name of bitmap array)
        Function to write a bitmap to the display */
        void writeBitmap(const int *ptrBitmap);
    
    
        void locateChar(int page, int column);
        
  protected:     
        
        virtual int _putc(int value);
        virtual int _getc();
         
         /* writeCommand(Command to send to display)
       Function to write a command to the display
       RS is low for commands */
       
       void writeCommand(int command);
       
    /* writeData(Data to send to display RAM)
       Function to send data to the display */
       
       void writeData(int data);
   
    /* writeByte(Byte to send to the display via the data bus)
        Function to write a byte to the display */
        
        void writeByte(int value); 
    /*Initialize Digital Outputs for RS signal and E signal */
    
         void writeChar5x8(int p, int col, int c);
         
    DigitalOut _rs, _e, _rst, _led;
    
    /*Initialize bus for data*/
    
    BusOut _d;
            
    int _page;
    int _column;
    
};


#endif