//programa para celular siemens que recibe un mensaje de texto t activa una salida en formato
//pdu hex
//VERSION ABRIL 28-2017
#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
DebouncedIn button1(PTC12);  
Serial GSM(PTE0,PTE1);  //puertos del FRDM para el modem
Serial pc(USBTX,USBRX);
void Rx_interrupt();
int position=0;
int lenpack=6;
int longi=0;
char tel[10];
char DE[50];
char buffer[512];
char buffermsg[100];
char buffer1[13];
char mensaje[100];
char NUMBER[13];    
int index;
int count;
int i = 0;
int c=0;
int cont=0;
unsigned char CtrlZ = 0x1A; 
bool Flag = false; 
char r[]=""; 
char msg[256];
char char1;
//---------------------------------------------------------------
void FlushGSM(void) { 
char1 = 0;
 while (GSM.readable()){
     char1 = GSM.getc();}
     return;}
//----------------------------------------------------------------
void callback() {
   
    pc.printf("%c\n", GSM.getc());
    
}
 
int readBuffer(char *buffer,int count)
{
    int i=0; 
    t.start(); 
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()) {  
        char c = GSM.getc();
    }
    return 0;
}
//------------------------------------------------------------------------
void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
//----------------------------------------------------------------------
void sendCmd(char *cmd)
{
    GSM.puts(cmd);
}

int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    t.start();

    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;
            if(sum == len)break;  
        }
        if(t.read() > timeout) {  
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 
    t.reset();                    
    while(GSM.readable()) {     
        char c = GSM.getc();
    }

    return 0;
}
//----------------------------------------------------------------------------
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
//---------------------------------------------------------------------------
int powerCheck(void)
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
//----------------------------------------------------------------------------
int checkSIMStatus(void)
{
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer,30);
    while(count < 3) {
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) {
            break;
        }
        count++;
        wait(1);
    }

    if(count == 3) {
        return -1;
    }
    return 0;
}
//--------------------------------------------------------------------------------------------------
int checkSignalStrength(void)
{
    char gprsBuffer[100];
    int index,count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3) {
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3) {
        return -1;
    }
    return index;
}
//----------------------------------------------------------------------------------------
int init()
{
    for(int i = 0; i < 3; i++){
        sendCmdAndWaitForResp("AT\r\n", "OK", 1);
        wait(0.5);
    }
    if(0 != checkSIMStatus()) {
        return -1;
    }
    if(checkSignalStrength()<1) {
        return -1;
    }
   
    GSM.attach(&Rx_interrupt, Serial::RxIrq);
    return 0;
}
//-------------------------------------------------------------------------------------------------
int readSMSpdu(char *message, int index)
{
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0';
    }
    return 0;
}
//-----------------------------------------------------------------------------------
int deleteSMS(int index)
{
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}
//---------------------------------------------------------------------------------------------
void Rx_interrupt(){
     }
   
int main(void)
       { 
       
       LedVerde=1;
       LedRojo=1;
       LedAzul=1;
       lenpack=6; 
       GSM.baud(9600);
       GSM.format(8,Serial::None,1); 

       GSM.printf("AT\r\n");
       wait(0.5);
       GSM.printf("AT+CNMI=1,1\r\n");
       wait(0.5);
       GSM.printf("AT+CMGF=0\r\n");
       wait(0.5);
       GSM.printf("ATE\r\n");
       wait(0.5);
       GSM.printf("CBST=0,0,1\r\n");
       wait(0.5);  
       LedVerde=0;     
//------------------El Ciclico----------------------------------------      
        
      while(1){ 
      
       if (button1.falling())
        { LedVerde=1;
          wait(2);
           if (!button1)
           {LedVerde=0;
           index=20;
       
       GSM.printf("AT+CMGS=%d\r\n",index);
       wait(0.2);
       // onverde= 0011000A9113223717370000AA076FB7BD2C279701
       GSM.printf("0011000A9113223717370000AA076FB7BD2C279701");
       wait(0.5);
       GSM.putc((char)0x1A); 
       LedVerde=1;
       LedRojo=0;  
       wait(3);
       LedRojo=1;  
       LedVerde=0;          
       }
       }  
      
       if (GSM.readable()) {
            readBuffer(buffer,100);
            pc.printf("buffer= %s\n\r ",buffer);
            pc.printf("buffer= %c  %c\n\r ",buffer[10],buffer[11]);
                if(buffer[67]=='A'){for(i=0;i<86;i++)
                 {buffermsg[i]=buffer[i];}
                 pc.printf("mensaje= %s\n\r ",buffermsg); 
                 pc.printf("mensaje[72]= %c mensaje[73]=%c\n\r ",buffermsg[72],buffermsg[73]);        
                 buffer[67]='c';
                 }
                 
 if(buffer[10]=='S'&& buffer[11]=='M'){
             for(i=0;i<5;i++)
             {buffer1[i]=buffer[2+i];}
             pc.printf("buffer1= %s\n\r ",buffer1);         
             buffer[10]='c';
             buffer[11]='c';
             }
if(buffer1[3]=='T'){pc.printf("AT+CMGL=0\n\r");
            wait(0.5);
            GSM.printf("AT+CMGL=0\r\n");
            buffer1[3]='p';
            }
            

//   CC3219642FCBC965   ESTO SIGNIFICA "Led verde"  si mandan ese mensaje de texto se prende el led azul
         
if(buffermsg[70]=='C' && buffermsg[71]=='C' && buffermsg[72]=='3' && buffermsg[73]=='2' && buffermsg[74]=='1' && buffermsg[75]=='9' && buffermsg[76]=='6' && buffermsg[77]=='4' && buffermsg[78]=='2' && buffermsg[79]=='F' && buffermsg[80]=='C' && buffermsg[81]=='B' && buffermsg[82]=='C' && buffermsg[83]=='9' && buffermsg[84]=='6' && buffermsg[85]=='5'){LedAzul=0;}
if(buffermsg[72]=='7' && buffermsg[73]=='3'){LedAzul=1;}  //apaga con Lgeverde
               
         
    }            
}
}
/*
cadena real --Led verde=  0011000A9113223717370000AA09CC3219642FCBC965
esto llega luego de mandar -------------------Led verde----------------
buffer= 

 buffer= [00]  [00]

 buffer= $$+CMTI: "SM",1$$

 buffer= S  M

 buffer1= +CMTI

 AT+CMGL=0

buffer= $$+CMGL: 1,0,,26$$0791751330512411040AA1132237173700007140820173340A09CC3219642FCBC965$$$$OK$$

 buffer= ,  0

 mensaje= $$+CMGL: 1,0,,26$$0791751330512411040AA1132237173700007140820173340A09CC3219642FCBC965

 mensaje[72]= 3 mensaje[73]=2



*/