#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
AnalogIn Vin(PTC2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DebouncedIn button1(PTC12);
DebouncedIn button2(PTC13);
DebouncedIn button3(PTC16);
DebouncedIn button4(PTC17);

/*    codigos movimiento del curzor
      18 para izquierda
      1A para derecha
*/      


int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int i; // indice de la variable
int j;
int kp, ki, kd, sp, err, med, yr, pid, ap, ai, ad, err_v, cycle; 

int main() {
    lcd.cls();
    lcd.printf("Sp%d",sp);
    lcd.locate(8,0);
    lcd.printf("Kp%d",kp);
    lcd.locate(0,1);
    lcd.printf("Ki%d",ki);
    lcd.locate(8,1);
    lcd.printf("Kd%d",kd);
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("Sp%d",sp);
    
        
    while(1) {
           if (button3.falling()) {              
               ++j;
               }                                     //INCREMENTA POSICION DEL MENU COB BOTON 3
           if (j==0){
               lcd.locate(2,0);
               lcd.printf("%d",sp);
                  if (button1.falling()) {                            
                  ++sp; // ademas revisa boton 1 para incrementar
                                         }
                  if (button2.falling()) {                            
                  --sp; // ademas revisa boton 2 para decrementar
                                         } 
              }
           if (j==1) {
               lcd.locate(10,0);
               lcd.printf("%d",kp);
                  if (button1.falling()) {
                  ++kp;
                                         }
                  if (button2.falling()) {                            
                  --kp;
                                         }
              }
           if (j==2) {
               lcd.locate(2,1);
               lcd.printf("%d",ki);
                  if (button1.falling()){
                  ++ki;
                                        }
                  if (button2.falling()){                            
                  --ki;
                                        }               
              }
           if (j==3) {
               lcd.locate(10,1);
               lcd.printf("%d",kd);
                  if (button1.falling()){
                  ++kd;
                  }
                  if (button2.falling()){                            
                  --kd;
                  }
              } 
           if (j==4) {
               j=0;
               }                          
    
           if (button4.falling()){
           break;     //sale del bucle si pisan suiche4
               }
                        
                                        }
           lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
           lcd.cls(); //borra la pantalla
           lcd.printf("   GUARDADOS!"); 
           wait(2);
           lcd.cls();
           lcd.printf(" INICIA EL PID");
           wait(2);
           // se imprimen los parches del control  *****************************************
           lcd.cls();
           lcd.printf("Er%d",err);
           lcd.locate(8,0);
           lcd.printf("Me%d",med);
           lcd.locate(0,1);
           lcd.printf("Sp%d",sp);
           lcd.locate(8,1);
           lcd.printf("Co%d",pid);
           wait(5);
           
           // CICLO PRINCIPAL CONTROLADOR PID
           
           while(1) {
                              //leer puerto analogo y asignar a med
           err = (sp-med);
           ap = kp*err;
           ai =(ki*err)+ai;    //calculo de la integral del error
           // se verifica que la accion integral no sea muy grande
           ad = kd*(err-err_v); //calculo de la accion derivativa
           pid = (ap+ai+ad);
           //****se muestran las variables******************************************
           if (pid > 999){
           pid=1000;
           } 
           
           wait(.5);
           lcd.locate(2,0);
           lcd.printf("%d",err);
           lcd.locate(10,0);
           lcd.printf("%d",med);
           lcd.locate(2,1);
           lcd.printf("%d",sp);
           lcd.locate(10,1);
           lcd.printf("%d",pid);
           
           
           // se actualizan las variables *******************************************
           err_v = err;           
           // se verifica que pid sea positivo **************************************
           
           // se verifica que pid sea menor o igual la valor maximo *****************
           
           
           //  se envia el valor pid a puerto analogico de salida (D/A) **************
           //  se repite el ciclo
           }
}