/*Reloj despertador con módulo DS1307
*/

#include "mbed.h"
#include "PinDetect.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include "TextLCD.h"

// Configuracion puertos del microcontrolador
Rtc_Ds1307 rtc(PTE0, PTE1);                 // pines para la comunicacion I2C, SDA, SCL
Serial pc(USBTX, USBRX, "pc");              // puerto serie (USB)
QEI wheel(PTD5, PTD0, NC, 100);             // pines para el encoder
PinDetect Boton(PTA13, PullUp);             // boton encoder
PinDetect BotonA(PTE20, PullUp);            // boton apagar alarma
DigitalOut led1(LED_RED);                   // led rojo
DigitalOut led2(LED_GREEN);                 // led verde
DigitalOut led3(LED_BLUE);                  // led azul
DigitalOut buzzer(PTD3);                    // alarma
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // RS, E, D4, D5, D6, D7

// Declaracion de variables globales
int estado = 0, config = 0, dia = 1, mes = 1, ano = 2016, hora = 0, min = 0, configR = 0, cont = 1, set = 0, alarma = 0;

// Rutina presion boton
void keyPressed(void)
{
    if(estado == 0 && alarma == 1) {
        min++;
    }
    if(estado == 1 && set == 1) {
        config++;
    }
    if(estado == 2 && set == 1) {
        configR++;
        cont = 1;
    }
}

// Rutina presion sostenida boton
void keyPressedHeld(void)
{
    //wait(0.5);
    lcd.locate(0, 0);
    lcd.printf("                ");
    lcd.locate(0, 1);
    lcd.printf("                ");
    estado++;
    //lcd.cls();
    if(estado > 2) {
        estado = 0;
    }
}

// Rutina para apagar la alarma
void apagarAlarma(void)
{
    min--;
}
// Rutina principal
int main()
{
    // Configuracion de inicio y bienvenida
    Rtc_Ds1307::Time_rtc tm = {};
    Boton.setAssertValue(0);
    Boton.attach_asserted(&keyPressed);
    Boton.attach_asserted_held(&keyPressedHeld);
    Boton.setSamplesTillHeld(200);
    Boton.setSampleFrequency();
    BotonA.setAssertValue(0);
    BotonA.attach_asserted_held(&apagarAlarma);
    BotonA.setSamplesTillHeld(200);
    BotonA.setSampleFrequency();
    led1 = 1;
    led2 = 1;
    led3 = 1;
    buzzer = 0;
    lcd.printf("     Reloj");
    lcd.locate(0, 1);
    lcd.printf("  despertador");
    wait(3);
    lcd.locate(0, 0);
    lcd.printf("                ");
    lcd.locate(0, 1);
    lcd.printf("                ");
    wait(0.5);

    // Ciclo infinito
    while(1) {
        // Reloj en funcionamiento
        while(estado == 0) {
            led1 = 1;
            led2 = 0;
            led3 = 1;
            rtc.getTime(tm);
            lcd.locate(0, 0);
            lcd.printf("    %02d:%02d:%02d   ", tm.hour, tm.min, tm.sec);
            lcd.locate(0, 1);
            lcd.printf(" %s %02d/%02d/%04d", rtc.weekdayToString(tm.wday), tm.date, tm.mon, tm.year);
            if(tm.hour == hora && tm.min == min && tm.mon == mes && tm.date == dia && tm.year == ano) {
                buzzer = !buzzer;
                alarma = 1;
            } else {
                buzzer = 0;
                alarma = 0;
            }
            if(tm.hour <= hora && tm.min <= min && tm.mon <= mes && tm.date <= dia && tm.year <= ano) {
                lcd.locate(15, 0);
                lcd.printf("@");
            } else {
                lcd.locate(15, 0);
                lcd.printf(" ");
            }
            wait(1);
        }
        // Configuracion de la alarma
        while(estado == 1) {
            led1 = 1;
            led2 = 1;
            led3 = 0;
            wait(0.2);
            if(config == 0) {
                lcd.locate(0, 0);
                lcd.printf("   Establecer");
                lcd.locate(0, 1);
                lcd.printf("alarma: ");
                set = set + wheel.getPulses();
                wheel.reset();
                if(set > 1) {
                    set = 0;
                }
                if(set < 0) {
                    set = 1;
                }
                lcd.locate(8, 1);
                if(set == 0) {
                    lcd.printf("NO       ");
                } else if(set == 1) {
                    lcd.printf("SI       ");
                }
            }
            if(config == 1) {
                dia = dia + wheel.getPulses();
                wheel.reset();
                if(dia > 31) {
                    dia = 1;
                }
                if(dia < 1) {
                    dia = 31;
                }
                lcd.locate(0, 1);
                lcd.printf("Dia: %02d           ", dia);
            }
            if(config == 2) {
                mes = mes + wheel.getPulses();
                wheel.reset();
                if(mes > 12) {
                    mes = 1;
                }
                if(mes < 1) {
                    mes = 12;
                }
                lcd.locate(0, 1);
                lcd.printf("Mes: %02d           ", mes);
            }
            if(config == 3) {
                ano = ano + wheel.getPulses();
                wheel.reset();
                if(ano > 3000) {
                    ano = 2016;
                }
                if(ano < 2016) {
                    ano = 3000;
                }
                lcd.locate(0, 1);
                lcd.printf("Anno: %02d       ", ano);
            }
            if(config == 4) {
                hora = hora + wheel.getPulses();
                wheel.reset();
                if(hora > 23) {
                    hora = 0;
                }
                if(hora < 0) {
                    hora = 23;
                }
                lcd.locate(0, 1);
                lcd.printf("Hora: %02d       ", hora);
            }
            if(config == 5) {
                min = min + wheel.getPulses();
                wheel.reset();
                if(min > 59) {
                    min = 0;
                }
                if(min < 0) {
                    min = 59;
                }
                lcd.locate(0, 1);
                lcd.printf("Minutos: %02d        ", min);
            }
            if(config == 6) {
                lcd.locate(0, 1);
                lcd.printf("  Establecida   ");
                estado = 0;
                config = 0;
                wait(2);
            }
        }
        // Configuracion del reloj
        while(estado == 2) {
            led1 = 0;
            led2 = 1;
            led3 = 1;
            wait(0.2);
            if(configR == 0) {
                lcd.locate(0, 0);
                lcd.printf("Configurar reloj");
                set = set + wheel.getPulses();
                wheel.reset();
                if(set > 1) {
                    set = 0;
                }
                if(set < 0) {
                    set = 1;
                }
                lcd.locate(0, 1);
                if(set == 0) {
                    lcd.printf("       NO       ");
                } else if(set == 1) {
                    lcd.printf("       SI       ");
                }
            }
            if(configR == 1) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 31) {
                    cont = 1;
                }
                if(cont < 1) {
                    cont = 31;
                }
                lcd.locate(0, 1);
                lcd.printf("Dia: %02d        ", cont);
                tm.date = cont;
            }
            if(configR == 2) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 12) {
                    cont = 1;
                }
                if(cont < 1) {
                    cont = 12;
                }
                lcd.locate(0, 1);
                lcd.printf("Mes: %02d        ", cont);
                tm.mon = cont;
            }
            if(configR == 3) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 3000) {
                    cont = 2016;
                }
                if(cont < 2016) {
                    cont = 2016;
                }
                lcd.locate(0, 1);
                lcd.printf("Anno: %02d    ", cont);
                tm.year = cont;
            }
            if(configR == 4) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 7) {
                    cont = 1;
                }
                if(cont < 1) {
                    cont = 7;
                }
                lcd.locate(0, 1);
                lcd.printf("Dia semana: %1d", cont);
                tm.wday = cont;
            }
            if(configR == 5) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 23) {
                    cont = 0;
                }
                if(cont < 0) {
                    cont = 23;
                }
                lcd.locate(0, 1);
                lcd.printf("Hora: %02d       ", cont);
                tm.hour = cont;
            }
            if(configR == 6) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 59) {
                    cont = 0;
                }
                if(cont < 0) {
                    cont = 59;
                }
                lcd.locate(0, 1);
                lcd.printf("Minutos: %02d  ", cont);
                tm.min = cont;
            }
            if(configR == 7) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 59) {
                    cont = 0;
                }
                if(cont < 0) {
                    cont = 59;
                }
                lcd.locate(0, 1);
                lcd.printf("Segundos: %02d  ", cont);
                tm.sec = cont;
            }
            if(configR == 8) {
                lcd.locate(0, 1);
                lcd.printf("  Establecido   ");
                rtc.setTime(tm, false, false);
                rtc.startClock();
                estado = 0;
                configR = 0;
                wait(2);
            }
        }
    }
}