///Tarea de comunicación celular y módulo GPS 
//programa para celular siemens que recibe un mensaje de texto y activa una salida en formato
//pdu hex
#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
#include "GPS.h"
//Salidas digitales
Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);

//Declaración de los puertos de la FRDm, modem y GPS
 
Serial GSM(PTE0,PTE1);  //puertos del FRDM para el modem
Serial pc(USBTX,USBRX);
GPS gps(PTE22, PTE23);   // Puerto del FDRM para el gps 

//Declaración de variables

//Cadenas de caracteres con las que se va a trabajar
short DE[255];
short DS[255];
char buffer[512];
char buffermsg[100];
char buffer1[13];
char mensaje[100];
//Variables enteras y caracteres
int count;
int i,K,LENOUT,LENIN,C;
int c=0;
int cont=0;
unsigned char CtrlZ = 0x1A; 
bool Flag = false; 
char r[]=""; 
char msg[256];
char char1;
int index;
//Adquisición de números de teléfono, emisor - receptor
char Tel[15];
char cel[15];
char ojala[15]; // OJO

//El GPS entregará al celular coordenadas expresadas en latitud y longitud según la ubicación que encuentre
// por tanto se declaran estas variables:

float lo,la;
char clo[255], cla[255];   //Cadenas a capturar para latitud y longitud
int LENINlo,LENINla,LENINla_lo;
char la_lo[255];
//Cadena de google maps
char http2[255];
char http[] = "http://maps.google.com/maps?q=";

//Conversión octetos septetos

int iht,Kht,ChtLENOUTht,LENINht;
int ioct,Koct,LENOUToct,LENINoct,Coct;
char DEoct[255];
char DSoct[255];
char buf[100];

//Relleno de datos - con el fin de que tengan el mismo número de caracteres

char relle1[]=  "0011000A91";
char relle2[]=  "10000AA";
char relle3[]=     "68";

//Funciones del programa
 
int readBuffer(char *buffer,int count)
{
    int i=0; 
    t.start(); 
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
       if(i > count)break;     // ojooo
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    
    wait(0.5);
    while(GSM.readable()) {  
        char c = GSM.getc();
    }
    return 0;
}

//Programas a ejecutar
    
int main(void)
       { 
//LED´S en alto
       LedVerde=1;
       LedRojo=1;
       LedAzul=1;
//Tasa de baudios 
       GSM.baud(9600);
       GSM.format(8,Serial::None,1); 
//Lectura del modem
       GSM.printf("AT\r\n");
       wait(0.5);
       GSM.printf("AT+CNMI=1,1\r\n");
       wait(0.5);
       GSM.printf("AT+CMGF=0\r\n");
       wait(0.5);
       GSM.printf("ATE\r\n");
       wait(0.5);
       GSM.printf("CBST=0,0,1\r\n");
       wait(0.5);  
                
     while(1){ 
//Lectura del buffer          
       if (GSM.readable()) {
            readBuffer(buffer,100);
            pc.printf("buffer= %s\n\r ",buffer);
            pc.printf("buffer= %c  %c\n\r ",buffer[10],buffer[11]);
                if(buffer[67]=='A'){for(i=0;i<86;i++)
                 {buffermsg[i]=buffer[i];}
                 pc.printf("mensaje= %s\n\r ",buffermsg); 
                 pc.printf("mensaje[72]= %c mensaje[73]=%c\n\r ",buffermsg[72],buffermsg[73]);        
                 buffer[67]='c';
 //Si llegan estos tres tipos de mensajes...                
                 if (buffermsg[69] == '2'){    // PARA CUANDO LA CLAVE ES On
                        LENIN=2; //numero de caracteres de abajo son los octetos
                        DE[0]=0x47;
                        DE[1]=0x37;
                     }
                 if (buffermsg[69] == '3'&& buffermsg[70] == '4'){  // PARA CUANDO LA CLAVE ES Off
                        LENIN=3; //numero de caracteres de abajo son los octetos
                        DE[0]=0x4F;
                        DE[1]=0xB3;
                        DE[2]=0x19;
                    }
//Recepción de las coordenadas otorgadas por el GPS
                  if (buffermsg[69] == '3'&& buffermsg[70] == 'C'){  // PARA CUANDO LA CLAVE ES Cor
                        LENIN=3; //numero de caracteres de abajo son los octetos
                        DE[0]=0xC3;
                        DE[1]=0xB7;
                        DE[2]=0x1C;
                    }
                 
                    LENOUT= LENIN*8/7;
                    K=7;
                    C=0;
                    DS[0]=DE[0] & 0x7F;  // la primera sola
                    pc.printf("%2X\n",DS[0]);
                   
                    for (i=1;i < LENOUT;i++){  // inicia el algoritmo
                        DS[i]=(DE[i-1-C]>>K | DE[i-C]<<(8-K))& 0x7F;  //valido para todos
                        pc.printf("%2X\n",DS[i]);
                        
                        if (K==0) {K=8;C++;}
                    K--;
                    }
                    
                    for (i=0 ;i<=9;i++)  
                    {
                     Tel[i] = buffermsg[40+i];
                    }   
//Lectura del número de teléfono
                    pc.printf("\n");
                    pc.printf("%c%c%c%c%c%c%c%c%c%c",Tel[1],Tel[0],Tel[3],Tel[2],Tel[5],Tel[4],Tel[7],Tel[6],Tel[9],Tel[8]);          
                 }                     
        if(buffer[10]=='S'&& buffer[11]=='M'){
             for(i=0;i<5;i++)
             {buffer1[i]=buffer[2+i];}
             pc.printf("buffer1= %s\n\r ",buffer1);         
             buffer[10]='c';
             buffer[11]='c';
             }
        if(buffer1[3]=='T'){pc.printf("AT+CMGL=0\n\r");
            wait(0.5);
            GSM.printf("AT+CMGL=0\r\n");
            buffer1[3]='p';
            }     
        if(DS[0]-67 == 0&& DS[1]-111==0)   // Cor en octetos es 436f72
        {
        pc.printf("\n");
        LedAzul=0;
        
        DS[0] = '\0';
        DS[1] = '\0';
//Entrega los datos de longitud y latitud
           if(gps.sample())
            {
               lo =gps.longitude;
               la =gps.latitude;
               pc.printf("longitud_entera=%f, Latitud entera=%f\n", lo, la);
                  wait(0.5);   
                        
            //LONGITUD/        
            sprintf (clo, "%f", lo); 
            pc.printf ( "\nlongitud = %s\n",clo);
            LENINlo=strlen(clo);  
            wait(0.5);
            
           //LATITUD/
           sprintf (cla, "%f", la); 
           pc.printf ( "\nlatitud = %s\n",cla);
           LENINla=strlen(cla); 
         
        //Concatenando las cadenas de Latitud y Longitud...

           strcpy(la_lo,cla);
           strcat(la_lo,",");
           strcat(la_lo,clo);
               
           pc.printf ( "\nla_lo: %s\n",la_lo);
           
           LENINla_lo=strlen(la_lo);

         //Ahora se juntan las cadenas obtenidas y se agrega el protocolo de transferencia de hipertextos http
            strcpy(http2,http);
            strcat(http2,la_lo);         
            pc.printf ( "%s\n",http2);
            pc.printf ( "\n" );
           
           
        //Conversión de la cadena de http2 de octetos a septetos 
       
        LENINht=strlen(http2);
        pc.printf("%d\n",LENINht); 
        for (iht=0;iht<LENINht;iht++){
             pc.printf("%2X",http2[iht]);       
            } 
        pc.printf ( "\n" );

        LENINoct=strlen(http2);
        pc.printf("%d\n",LENINoct);
            for (ioct=0;ioct<LENINoct;ioct++)
          {
                DEoct[ioct]=http2[ioct];
                pc.printf("%2X,%d\n",DEoct[ioct],ioct);       
           }

         Koct=0;
         Coct=0;
        
         for (ioct=0;ioct < LENINoct;ioct++)
         {
                DSoct[ioct]=DEoct[ioct+Coct]>>Koct | DEoct[ioct+Coct+1]<<(7-Koct);
                if (DSoct[ioct]==0x00){
                    LENOUToct=ioct; 
                    pc.printf("\n");
                    pc.printf("%s",DEoct);
                    pc.printf("out =%d",LENOUToct);
                        for (ioct=0;ioct<LENOUToct;ioct++){
                            pc.printf("%2X,%d\r\n",DSoct[ioct]&0x000000FF,ioct);
                        }
                  }
                  
                 Koct++;
                if (Koct==7)
                {
                Koct=0;Coct++;
                } // se chequea que ya se acabaron los bits en un ciclo de conversion.
         }  
        
        //Concatenación de los datos relleno y el número de celular
        wait(5);
        index=56;
        GSM.printf("AT+CMGS=%d\r\n",index);
        pc.printf("AT+CMGS=%d\r\n",index);
        pc.printf("0011000A91");
         GSM.printf("0011000A91");
             for (i=0 ;i<=9;i++)  
                    {
                    pc.printf("%c",Tel[i]);
                    GSM.printf("%c",Tel[i]);
                    }  
        pc.printf("10000AA");
        GSM.printf("0000AA");
         pc.printf("31");
        GSM.printf("31");
                 
           for (ioct=0;ioct<=((LENOUToct*7)/8);ioct++)
         {
           pc.printf("%02X",DSoct[ioct]);
           GSM.printf("%02X",DSoct[ioct]);
         }
         wait(0.5);
         GSM.putc((char)0x1A);
          GSM.scanf("%s",buf);
            GSM.scanf("%s",buf);
            GSM.scanf("%s",buf);
            //GSM.scanf("%s",buf);
            pc.printf(">%s\n",buf);
          pc.printf("\n");
          
           }
        }
//Si el mensaje recibido fue OFF...
        if(DS[0]-79==0 && DS[1]-102==0)     // Off en octetos es 4F6666
        {
            //Secuencia de apagado
               LedAzul=1;
               LedVerde = 0;
               LedRojo=1;
        }   
//Si el mensaje recibido fue ON...       
        if(DS[0]-71==0 && DS[1]-110==0)  // On en octetos es 476E
        {
                //Secuencia de apagado
               LedAzul=1;
               LedRojo =0;
               LedVerde = 1;
        } 
     }           
}
}