//demo display y encoder
//programa para probar un bluepill con encoder y lcd y pulsadores
//control de soldador de punto de doble pulso
//se emiten dos pulsos y una  espera intermedia
//antes de hacer esto se carga un condensador de 5F por 3seg con  el IGBT1
//luego se envian los pulsos de soldadura por el IGBT, con los tiempos configurados
#include "mbed.h"
#include "TextLCD.h"
#include "QEI.h"

// se configura el lcd en este caso uno de cuatro filas
TextLCD lcd(PA_8, PA_9, PA_10, PA_11, PA_12, PA_15, TextLCD::LCD16x4);  // 4-bit bus: RS, E, D4, D5, D6, D7

int p=0,p1=0,p2=0,espera=0,pulsos=0;            //variables del programa
int i=0;                          //posicion de la variable en el display
QEI wheel (PB_3, PB_4, NC, 100);  //configuramos encoder de libreria. dos fases y pulsos x rev
InterruptIn button(PB_5);
DigitalIn fire(PB_7);  //boton pedal para soldar
DigitalOut IGBT(PB_6); //señal para el igbt
DigitalOut IGBT1(PB_8); //señal para el igbt1 de carga del condensador

void flip() {
      wait_ms(100);
      if(button==0){  
       i++;
       if(i>2){
           i=0;
              }
}
}

void weld() {
      if(fire==0){  
      IGBT1=1; // carga el condensador
      wait(3); //tres segundos
      IGBT1=0; //fin de la carga
      
      IGBT=0;
      wait_ms(10);
      IGBT=1;
      wait_ms(p1);
      IGBT=0;
      wait_ms(espera);
      IGBT=1;
      wait_ms(p2);
      IGBT=0;
      wait(3);
}
}
    
//..............................INICIA EL PROGRAMA.......................................................
int main()
{ 
//...............PANTALLA INICIAL...........................................
inicio1:             
    button.fall(&flip); 
    IGBT1=0; //apaga el igbt de carga
    lcd.cls();     
    lcd.locate(3,0);            //se posiciona en col 3 y fila 0
    lcd.printf("SPOT WELDER");  //primer mensaje
    lcd.locate(3,1);            //se posiciona en col 3 y fila 0
    lcd.printf("DUAL PULSE");   //primer mensaje
    wait(3);                    //espera 3 seg     
    lcd.cls();                  //borra pantalla
    lcd.locate(0,0);            //se posiciona en col 8 y fila 0
    lcd.printf("P1=");      //se marca una variable
    lcd.locate(8,0);            //se posiciona 0,1 
    lcd.printf("P2=");      //se marca una variable
    lcd.locate(0,1);            //se  posiciona en 8,1
    lcd.printf("Esp=");       //se marca una variable
    lcd.setCursor(TextLCD::CurOff_BlkOn);   //se configura el cursor LCD parpadeante.
     
//..............................FIN PANTALLA INICIAL.....................................    
//.............programa ciclico..........................................................
  while(1){
  
if(i==0){
lcd.locate(3,0);
lcd.printf("  ");
p1=wheel.getPulses();
if(p1<0){
    p1=0;
    }
lcd.locate(3,0);
lcd.printf("%d",p1);
wait_ms(60);

        }
if(i==1){
lcd.locate(11,0);
lcd.printf("  ");
p2=wheel.getPulses();
if(p2<0){
    p2=0;
    }
lcd.locate(11,0);
lcd.printf("%d",p2);
wait_ms(60);


        }
if(i==2){
lcd.locate(4,1);
lcd.printf("  ");
espera=wheel.getPulses();
if(espera<0){
    espera=0;
    }
lcd.locate(4,1);
lcd.printf("%d",espera);
wait_ms(60);

        }
if(fire==0){
    weld();
/*  lcd.cls();
    lcd.printf("WELD-OK");
    wait(2);
    goto inicio1;
*/    
    }       
}//while        
}//main