#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTA16, PTA17, NC, 48);

DebouncedIn button_enco(PTC5);

PwmOut Sonido(PTA5);

float periodo;
float Frecuencia=4000;
int C1=0x0C;
int m;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int visual=0;
int alarma=0;  

int main()
{
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarm = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    
    lcd.locate(0,0);
    lcd.printf("--Alarma  --Hora");
    
    periodo=(1/Frecuencia);
    Sonido.period(periodo);
    
    rtc.getTime(tm); //lee el tiempo del DS1307

    while(1)
    {
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                 if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
            case 1:
                switch(i)
                {
                    case 0:
                    
                                              
                        if(Conf==0)
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Alarma ");
                            wait(1);
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                            tm.date=1;                             
                        }
                
                        if(Conf==1)
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. hora   ");
                            wait(1);
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                            
                        }    

                    break;
                    
                    case 1:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.date=tm.date+m;
                            if(tm.date>31)
                            {
                                tm.date=31;
                            }
                            if(tm.date<1)
                            {
                                tm.date=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d",tm.date);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            //tm.mon=1;
                        }
                    
                    break;
                    
                    case 2:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.mon=tm.mon+m;
                            if(tm.mon>12)
                            {
                                tm.mon=12;
                            }
                            if(tm.mon<1)
                            {
                                tm.mon=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Year: ");
                            
                        }
                    
                    break;
                    
                    case 3:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.year=tm.year+m;
                            
                            if(tm.year<2000)
                            {
                                tm.year=2000;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hora: ");
                            
                        }
                    
                    break;
                    
                     case 4:
                        m=wheel.getPulses();
                                
                        if (m!=0) 
                        {
                            tm.hour=tm.hour + m;
                            if(tm.hour>23)
                            {
                                tm.hour=23;
                            }
                            if(tm.hour<0)
                            {
                                tm.hour=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Minuto: ");
                            //tm.min=0;
                        }
                    
                    break;
                    
                    case 5:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.min=tm.min+m;
                            if(tm.min>59)
                            {
                                tm.min=59;
                            }
                            if(tm.min<0)
                            {
                                tm.min=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Segundo: ");
                            //tm.sec=0;
                        }
                    
                    break;
                    
                    
                    case 6:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.sec=tm.sec+m;
                            if(tm.sec>59)
                            {
                                tm.sec=59;
                            }
                            if(tm.sec<0)
                            {
                                tm.sec=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(9,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            if(Conf==0)
                            {
                                Alarm=tm;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Alarma config. ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar++;
                                lcd.cls();
                                                          
                            }
                
                            if(Conf==1)
                            {
                                rtc.setTime(tm, false, false);
                                rtc.startClock();
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Hora Config.  ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar=0;
                                lcd.locate(0,0);
                                lcd.printf("--Alarma  --Hora");                                
                            } 
                           
                           ///////////////////
                        }
                    
                    break;
                   
                }            
            break;
            
            case 2:
            
                rtc.getTime(tm);
                           
                if(visual==0)
                {
                    
                    lcd.locate(0,0);                        
                    lcd.printf("Hora:   ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",tm.hour);
                    lcd.printf("%02d:",tm.min);
                    lcd.printf("%02d",tm.sec); 
                       
                    lcd.locate(0,1);
                    lcd.printf("%02d/",tm.mon);
                    lcd.printf("%02d/",tm.date);
                    lcd.printf("%02d",tm.year);
                    wait(0.1);
                    //////////
                    m=wheel.getPulses();
                    if(m!=0)
                    {
                        visual=1;
                        wheel.reset();  
                        m=0;
                    }
                    
                    //////
                
                }
                
                if(visual==1)
                {
                    lcd.locate(0,0);    
                    lcd.printf("Alarma: ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",Alarm.hour);
                    lcd.printf("%02d:",Alarm.min);
                    lcd.printf("%02d",Alarm.sec);
                    
                        
                    lcd.locate(0,1);
                    lcd.printf("%02d/",Alarm.mon);
                    lcd.printf("%02d/",Alarm.date);
                    lcd.printf("%02d",Alarm.year);
                    wait(0.1);
                    ////
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        visual=0;
                        wheel.reset();  
                        m=0;                                       
                    }
                    
                    ////
                }
                
                if( (tm.date==Alarm.date)&&(tm.mon==Alarm.mon)&&(tm.year==Alarm.year)&&(tm.hour==Alarm.hour)&&(tm.min==Alarm.min)&&(tm.sec==Alarm.sec) )
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma Activa!!!");
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("->Desactivar    ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar       ");
                    m=0;
                }
                 
            break;
            
            case 3:
                
                if(alarma==0)
                {
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=1;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf("-");                    
                        lcd.locate(1,1);
                        lcd.printf(">");                                          
                    }
                }
                          
                ///////////////////
                
                if(alarma==1)
                {
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=0;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf(">");                    
                        lcd.locate(1,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling())
                {
                    if(alarma==0)
                    {
                        Lugar=0;
                        wheel.reset();
                        m=0;
                        Sonido.write(0);
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("--Alarma  --Hora");
                        
                    }
                    if(alarma==1)
                    {
                        Lugar=2;
                        rtc.getTime(tm);
                        if(tm.min!=58)
                        {
                            Alarm.min=tm.min+1;
                        }
                        if(tm.min==59)
                        {
                            Alarm.min=0;
                            Alarm.hour=tm.hour+1;
                        }
                        Alarm.sec=tm.sec;
                        lcd.cls();
                        alarma=0;
                        
                    }
                    
                }
                
            
            break;
        }             
    }       
}