 
#include "Pulse1.h"

PulseInOut::PulseInOut(PinName pin):
        startval(0), pulsetime(), runtime(), io(pin)    {
}


PulseInOut::~PulseInOut() {
}

void PulseInOut::write(int val) {
    io.output();
    io = val;
}

void PulseInOut::write_us(int val, int time)   {
    io.output();
    io = val;
    wait_us(time);
    io = !val;
}

int PulseInOut::read_high_us()  {
    pulsetime.reset();
    io.input();
    while (io == 1) {
    }
    while (io == 0) {
    }
    pulsetime.start();
    while (io == 1) {
    }
    pulsetime.stop();
    return pulsetime.read_us();
}

int PulseInOut::read_high_us(int timeout)  {
    runtime.reset();
    runtime.start();
    pulsetime.reset();
    io.input();
    while (io == 1) {
        if (runtime.read_us() > timeout)   return -1;
    }
    while (io == 0) {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.start();
    while (io == 1) {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.stop();
    return pulsetime.read_us();
}

int PulseInOut::read_low_us()   {
    pulsetime.reset();
    io.input();
    while (io == 0) {
    }
    while (io == 1) {
    }
    pulsetime.start();
    while (io == 0) {
    }
    pulsetime.stop();
    return pulsetime.read_us();
}

int PulseInOut::read_low_us(int timeout)   {
    runtime.reset();
    runtime.start();
    pulsetime.reset();
    io.input();
    while (io == 0) {
        if (runtime.read_us() > timeout)   return -1;
    }
    while (io == 1) {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.start();
    while (io == 0) {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.stop();
    return pulsetime.read_us();
}

int PulseInOut::read_us()  {
    pulsetime.reset();
    io.input();
    startval = io;
    while (io == startval)   {
    }
    pulsetime.start();
    while (io != startval)  {
    }
    pulsetime.stop();
    return pulsetime.read_us();
}

int PulseInOut::read_us(int timeout)   {
    runtime.reset();
    runtime.start();
    pulsetime.reset();
    io.input();
    startval = io;
    while (io == startval)  {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.start();
    while (io != startval)   {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.stop();
    return pulsetime.read_us();
}